/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.resources;

import org.apache.camel.ProducerTemplate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.monitor.resources.TxsResource;
import org.springframework.http.ResponseEntity;

public class TxsResource_addTxTest {
    @Test
    public void testAddTx_nullTemplate_assertExcecption() {
        Tx tx = (Tx)Mockito.mock(Tx.class);
        TxsResource resource = new TxsResource(null, null);
        boolean exceptionOccured = false;
        try {
            resource.addTx(tx);
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testAddTx_exceptionInSubmission_assertErrorCode() {
        ProducerTemplate template = (ProducerTemplate)Mockito.mock(ProducerTemplate.class);
        ((ProducerTemplate)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("")}).when((Object)template)).sendBody(ArgumentMatchers.any());
        Tx tx = (Tx)Mockito.mock(Tx.class);
        TxsResource resource = new TxsResource(template, null);
        ResponseEntity res = resource.addTx(tx);
        Assertions.assertEquals((int)500, (int)res.getStatusCodeValue());
    }

    @Test
    public void testAddTx_exceptionInSubmission_assertCreatedCode() {
        ProducerTemplate template = (ProducerTemplate)Mockito.mock(ProducerTemplate.class);
        Tx tx = (Tx)Mockito.mock(Tx.class);
        TxsResource resource = new TxsResource(template, null);
        ResponseEntity res = resource.addTx(tx);
        Assertions.assertEquals((int)201, (int)res.getStatusCodeValue());
    }
}

