/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.resources;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.monitor.processor.DuplicateNotificationStateManager;
import org.nhindirect.monitor.processor.DuplicateNotificationStateManagerException;
import org.nhindirect.monitor.resources.TxsResource;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;

public class TxResource_suppressNotificationTest {
    @Test
    public void testSuppressNotification_nullDAO_assertExcecption() {
        Tx tx = (Tx)Mockito.mock(Tx.class);
        TxsResource resource = new TxsResource(null, null);
        boolean exceptionOccured = false;
        try {
            resource.supressNotification(tx);
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testSuppressNotification_suppressFalse_assertFalseAnd200StatusCode() {
        Tx tx = (Tx)Mockito.mock(Tx.class);
        DuplicateNotificationStateManager dupMgr = (DuplicateNotificationStateManager)Mockito.mock(DuplicateNotificationStateManager.class);
        TxsResource resource = new TxsResource(null, dupMgr);
        ResponseEntity res = resource.supressNotification(tx);
        Assertions.assertEquals((int)200, (int)res.getStatusCodeValue());
        Assertions.assertFalse((boolean)((Boolean)((Mono)res.getBody()).block()));
    }

    @Test
    public void testSuppressNotification_suppressTrue_assertTrueAnd200StatusCode() throws Exception {
        Tx tx = (Tx)Mockito.mock(Tx.class);
        DuplicateNotificationStateManager dupMgr = (DuplicateNotificationStateManager)Mockito.mock(DuplicateNotificationStateManager.class);
        Mockito.when((Object)dupMgr.suppressNotification(tx)).thenReturn((Object)true);
        TxsResource resource = new TxsResource(null, dupMgr);
        ResponseEntity res = resource.supressNotification(tx);
        Assertions.assertEquals((int)200, (int)res.getStatusCodeValue());
        Assertions.assertTrue((boolean)((Boolean)((Mono)res.getBody()).block()));
    }

    @Test
    public void testSuppressNotification_mgrException_assert500StatusCode() throws Exception {
        Tx tx = (Tx)Mockito.mock(Tx.class);
        DuplicateNotificationStateManager dupMgr = (DuplicateNotificationStateManager)Mockito.mock(DuplicateNotificationStateManager.class);
        Mockito.when((Object)dupMgr.suppressNotification(tx)).thenThrow(new Throwable[]{new DuplicateNotificationStateManagerException()});
        TxsResource resource = new TxsResource(null, dupMgr);
        ResponseEntity res = resource.supressNotification(tx);
        Assertions.assertEquals((int)500, (int)res.getStatusCodeValue());
    }
}

