/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.processor.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.TestApplication;
import org.nhindirect.monitor.entity.ReceivedNotification;
import org.nhindirect.monitor.processor.impl.TimeoutDupStateManager;
import org.nhindirect.monitor.repository.ReceivedNotificationRepository;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.transaction.annotation.Transactional;

@ExtendWith(value={SpringExtension.class})
@DataJpaTest
@Transactional
@ContextConfiguration(classes={TestApplication.class})
@ActiveProfiles(value={"producerMock"})
public class TimeoutDupStateManager_addNotificationForOriginalRecipsTest {
    @Autowired
    private ReceivedNotificationRepository recRepo;

    @BeforeEach
    public void setUp() throws Exception {
        Calendar qualTime = Calendar.getInstance(Locale.getDefault());
        qualTime.add(1, 10);
        this.recRepo.deleteByReceivedTimeBefore(qualTime);
    }

    @Test
    public void testAddNotificationForOriginalRecips_nullDAO_assertException() throws Exception {
        TimeoutDupStateManager mgr = new TimeoutDupStateManager();
        boolean execptionOccured = false;
        try {
            mgr.addNotificationForOriginalRecips(new ArrayList());
        }
        catch (IllegalArgumentException e) {
            execptionOccured = true;
        }
        Assertions.assertTrue((boolean)execptionOccured);
    }

    @Test
    public void testAddNotificationForOriginalRecips_nullCollection_assertException() throws Exception {
        TimeoutDupStateManager mgr = new TimeoutDupStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        Assertions.assertThrows(IllegalArgumentException.class, () -> mgr.addNotificationForOriginalRecips(null));
    }

    @Test
    public void testAddNotificationForOriginalRecips_noRecips_assertNotificationNotAdded() throws Exception {
        TimeoutDupStateManager mgr = new TimeoutDupStateManager();
        ReceivedNotificationRepository dao = (ReceivedNotificationRepository)Mockito.mock(ReceivedNotificationRepository.class);
        mgr.setReceivedNotificationRepository(dao);
        Tx tx = TestUtils.makeMessage(TxMessageType.IMF, "1234", "", "", "", "");
        mgr.addNotificationForOriginalRecips(Arrays.asList(tx));
        ((ReceivedNotificationRepository)Mockito.verify((Object)dao, (VerificationMode)Mockito.never())).save((Object)((ReceivedNotification)ArgumentMatchers.any()));
    }

    @Test
    public void testAddNotificationForOriginalRecips_noOrigMsg_assertNotificationNotAdded() throws Exception {
        TimeoutDupStateManager mgr = new TimeoutDupStateManager();
        ReceivedNotificationRepository dao = (ReceivedNotificationRepository)Mockito.mock(ReceivedNotificationRepository.class);
        mgr.setReceivedNotificationRepository(dao);
        Tx tx = TestUtils.makeMessage(TxMessageType.MDN, "1234", "", "test@test.com", "me@you.com", "test@test.com");
        mgr.addNotificationForOriginalRecips(Arrays.asList(tx));
        ((ReceivedNotificationRepository)Mockito.verify((Object)dao, (VerificationMode)Mockito.never())).save((Object)((ReceivedNotification)ArgumentMatchers.any()));
    }

    @Test
    public void testAddNotificationForOriginalRecips_addSingleRecip_nonReliable_assertNotificationsNotAdded() throws Exception {
        TimeoutDupStateManager mgr = new TimeoutDupStateManager();
        ReceivedNotificationRepository dao = (ReceivedNotificationRepository)Mockito.mock(ReceivedNotificationRepository.class);
        mgr.setReceivedNotificationRepository(dao);
        Tx tx = TestUtils.makeMessage(TxMessageType.IMF, "1234", "", "test@test.com", "me@you.com", "test@test.com");
        mgr.addNotificationForOriginalRecips(Arrays.asList(tx));
        ((ReceivedNotificationRepository)Mockito.verify((Object)dao, (VerificationMode)Mockito.never())).save((Object)((ReceivedNotification)ArgumentMatchers.any()));
    }

    @Test
    public void testAddNotificationForOriginalRecips_addSingleRecip_assertNotificationsAdded() throws Exception {
        TimeoutDupStateManager mgr = new TimeoutDupStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        Tx tx = TestUtils.makeReliableMessage(TxMessageType.IMF, "1234", "", "test@test.com", "me@you.com", "test@test.com", "", "");
        mgr.addNotificationForOriginalRecips(Arrays.asList(tx));
        List recAddresses = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase("1234", Arrays.asList("me@you.com".toUpperCase()));
        Assertions.assertTrue((boolean)recAddresses.contains("me@you.com"));
    }

    @Test
    public void testAddNotificationForOriginalRecips_addMultipleRecips_assertNotificationsAdded() throws Exception {
        TimeoutDupStateManager mgr = new TimeoutDupStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        Tx tx = TestUtils.makeReliableMessage(TxMessageType.IMF, "1234", "", "test@test.com", "me@you.com,you@you.com", "test@test.com", "", "");
        mgr.addNotificationForOriginalRecips(Arrays.asList(tx));
        List recAddresses = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase("1234", Arrays.asList("me@you.com".toUpperCase(), "you@you.com".toUpperCase()));
        Assertions.assertTrue((boolean)recAddresses.contains("me@you.com"));
        Assertions.assertTrue((boolean)recAddresses.contains("you@you.com"));
    }

    @Test
    public void testAddNotificationForOriginalRecips_addDupRecip_assertNotificationsAdded() throws Exception {
        TimeoutDupStateManager mgr = new TimeoutDupStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        Tx tx = TestUtils.makeReliableMessage(TxMessageType.IMF, "1234", "", "test@test.com", "me@you.com,you@you.com", "test@test.com", "", "");
        mgr.addNotificationForOriginalRecips(Arrays.asList(tx));
        List recAddresses = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase("1234", Arrays.asList("me@you.com".toUpperCase(), "you@you.com".toUpperCase()));
        Assertions.assertTrue((boolean)recAddresses.contains("me@you.com"));
        Assertions.assertTrue((boolean)recAddresses.contains("you@you.com"));
        mgr.addNotificationForOriginalRecips(Arrays.asList(tx));
        recAddresses = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase("1234", Arrays.asList("me@you.com".toUpperCase(), "you@you.com".toUpperCase()));
        Assertions.assertEquals((int)2, (int)recAddresses.size());
    }
}

