/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.processor.impl;

import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.TestApplication;
import org.nhindirect.monitor.processor.DuplicateNotificationStateManagerException;
import org.nhindirect.monitor.processor.impl.DefaultDuplicateNotificationStateManager;
import org.nhindirect.monitor.repository.ReceivedNotificationRepository;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.transaction.annotation.Transactional;

@ExtendWith(value={SpringExtension.class})
@DataJpaTest
@Transactional
@ContextConfiguration(classes={TestApplication.class})
@DirtiesContext
@ActiveProfiles(value={"producerMock"})
public class DefaultDuplicateNotificationStateManager_suppressNotificationTest {
    @Autowired
    private ReceivedNotificationRepository recRepo;

    @BeforeEach
    public void setUp() throws Exception {
        Calendar qualTime = Calendar.getInstance(Locale.getDefault());
        qualTime.add(1, 10);
        this.recRepo.deleteByReceivedTimeBefore(qualTime);
    }

    @Test
    public void testSuppressNotification_nullDAO_assertException() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        boolean execptionOccured = false;
        try {
            mgr.suppressNotification((Tx)Mockito.mock(Tx.class));
        }
        catch (IllegalArgumentException e) {
            execptionOccured = true;
        }
        Assertions.assertTrue((boolean)execptionOccured);
    }

    @Test
    public void testSuppressNotification_nullTx_assertException() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        boolean execptionOccured = false;
        try {
            mgr.suppressNotification(null);
        }
        catch (IllegalArgumentException e) {
            execptionOccured = true;
        }
        Assertions.assertTrue((boolean)execptionOccured);
    }

    @Test
    public void testSuppressNotification_nonNotificationTx_assertFalse() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        Tx tx = TestUtils.makeMessage(TxMessageType.IMF, "1234", "", "", "", "gm2552@cerner.com");
        Assertions.assertFalse((boolean)mgr.suppressNotification(tx));
    }

    @Test
    public void testSuppressNotification_displayedDisposition_assertFalse() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        Tx tx = TestUtils.makeMessage(TxMessageType.MDN, "1234", "5678", "", "", "", "", "displayed");
        Assertions.assertFalse((boolean)mgr.suppressNotification(tx));
    }

    @Test
    public void testSuppressNotification_noOrigMessageId_assertFalse() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        Tx tx = TestUtils.makeMessage(TxMessageType.MDN, "1234", "", "", "", "gm2552@cerner.com", "", "error");
        Assertions.assertFalse((boolean)mgr.suppressNotification(tx));
    }

    @Test
    public void testSuppressNotification_noFinalRecip_assertFalse() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        Tx tx = TestUtils.makeMessage(TxMessageType.MDN, "1234", "5678", "", "", "", "", "error");
        Assertions.assertFalse((boolean)mgr.suppressNotification(tx));
    }

    @Test
    public void testSuppressNotification_recipNotInStore_assertFalse() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        Tx tx = TestUtils.makeMessage(TxMessageType.MDN, "1234", "5678", "", "", "gm2552@cerner.com", "", "error");
        Assertions.assertFalse((boolean)mgr.suppressNotification(tx));
    }

    @Test
    public void testSuppressNotification_recipInStore_assertTrue() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        Tx tx = TestUtils.makeMessage(TxMessageType.MDN, "1234", "5678", "", "", "gm2552@cerner.com", "", "error");
        mgr.addNotification(tx);
        Assertions.assertTrue((boolean)mgr.suppressNotification(tx));
    }

    @Test
    public void testAddNotification_daoError_assertException() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        boolean execptionOccured = false;
        ReceivedNotificationRepository spyDao = (ReceivedNotificationRepository)Mockito.mock(ReceivedNotificationRepository.class);
        ((ReceivedNotificationRepository)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("")}).when((Object)spyDao)).findByMessageidIgnoreCaseAndAddressInIgnoreCase((String)ArgumentMatchers.any(), (List)ArgumentMatchers.any());
        mgr.setReceivedNotificationRepository(spyDao);
        try {
            Tx tx = TestUtils.makeMessage(TxMessageType.DSN, "1234", "5678", "", "", "gm2552@cerner.com,ah4626@cerner.com");
            mgr.suppressNotification(tx);
        }
        catch (DuplicateNotificationStateManagerException e) {
            execptionOccured = true;
        }
        Assertions.assertTrue((boolean)execptionOccured);
    }
}

