/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.processor.impl;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.nhindirect.monitor.TestApplication;
import org.nhindirect.monitor.entity.ReceivedNotification;
import org.nhindirect.monitor.processor.impl.DefaultDuplicateNotificationStateManager;
import org.nhindirect.monitor.repository.ReceivedNotificationRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.transaction.annotation.Transactional;

@ExtendWith(value={SpringExtension.class})
@DataJpaTest
@Transactional
@ContextConfiguration(classes={TestApplication.class})
@ActiveProfiles(value={"producerMock"})
public class DefaultDuplicateNotificationStateManager_purgeTest {
    @Autowired
    private ReceivedNotificationRepository recRepo;

    @BeforeEach
    public void setUp() throws Exception {
        Calendar qualTime = Calendar.getInstance(Locale.getDefault());
        qualTime.add(1, 10);
        this.recRepo.deleteByReceivedTimeBefore(qualTime);
    }

    @Test
    public void testPurge_nullDAO_assertException() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        boolean execptionOccured = false;
        try {
            mgr.purge();
        }
        catch (IllegalArgumentException e) {
            execptionOccured = true;
        }
        Assertions.assertTrue((boolean)execptionOccured);
    }

    @Test
    public void testPurgeNotification_notificationNotYetPurgable_assertNotPurged() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        mgr.setMessageRetention(1);
        String messageId = UUID.randomUUID().toString();
        ReceivedNotification notif = new ReceivedNotification();
        notif.setAddress("gm2552@cerner.com");
        notif.setMessageid(messageId);
        notif.setReceivedTime(Calendar.getInstance(Locale.getDefault()));
        this.recRepo.save((Object)notif);
        List addresses = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase(messageId.toUpperCase(), Arrays.asList("gm2552@cerner.com".toUpperCase()));
        Assertions.assertEquals((int)1, (int)addresses.size());
        mgr.purge();
        addresses = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase(messageId.toUpperCase(), Arrays.asList("gm2552@cerner.com".toUpperCase()));
        Assertions.assertEquals((int)1, (int)addresses.size());
    }

    @Test
    public void testPurgeNotification_notificationnotificationPurged_assertNotPurged() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        mgr.setMessageRetention(-1);
        String messageId = UUID.randomUUID().toString();
        ReceivedNotification notif = new ReceivedNotification();
        notif.setAddress("gm2552@cerner.com");
        notif.setMessageid(messageId);
        notif.setReceivedTime(Calendar.getInstance(Locale.getDefault()));
        this.recRepo.save((Object)notif);
        List addresses = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase(messageId.toUpperCase(), Arrays.asList("gm2552@cerner.com".toUpperCase()));
        Assertions.assertEquals((int)1, (int)addresses.size());
        mgr.purge();
        addresses = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase(messageId.toUpperCase(), Arrays.asList("gm2552@cerner.com".toUpperCase()));
        Assertions.assertEquals((int)0, (int)addresses.size());
    }

    public void testPurgeNotification_daoError_assertException() throws Exception {
        Assertions.assertThrows(RuntimeException.class, () -> {
            DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
            ReceivedNotificationRepository spyDao = (ReceivedNotificationRepository)Mockito.mock(ReceivedNotificationRepository.class);
            ((ReceivedNotificationRepository)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("")}).when((Object)spyDao)).deleteByReceivedTimeBefore((Calendar)ArgumentMatchers.any());
            mgr.setReceivedNotificationRepository(spyDao);
            mgr.purge();
        });
    }
}

