/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.processor.impl;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.TestApplication;
import org.nhindirect.monitor.entity.ReceivedNotification;
import org.nhindirect.monitor.processor.DuplicateNotificationStateManagerException;
import org.nhindirect.monitor.processor.impl.DefaultDuplicateNotificationStateManager;
import org.nhindirect.monitor.repository.ReceivedNotificationRepository;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.transaction.annotation.Transactional;

@ExtendWith(value={SpringExtension.class})
@DataJpaTest
@Transactional
@ContextConfiguration(classes={TestApplication.class})
@ActiveProfiles(value={"producerMock"})
public class DefaultDuplicateNotificationStateManager_addNotificationTest {
    @Autowired
    private ReceivedNotificationRepository recRepo;

    @BeforeEach
    public void setUp() throws Exception {
        Calendar qualTime = Calendar.getInstance(Locale.getDefault());
        qualTime.add(1, 10);
        this.recRepo.deleteByReceivedTimeBefore(qualTime);
    }

    @Test
    public void testAddNotification_nullDAO_assertException() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        boolean execptionOccured = false;
        try {
            mgr.addNotification((Tx)Mockito.mock(Tx.class));
        }
        catch (IllegalArgumentException e) {
            execptionOccured = true;
        }
        Assertions.assertTrue((boolean)execptionOccured);
    }

    @Test
    public void testAddNotification_nullTx_assertException() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        boolean execptionOccured = false;
        try {
            mgr.addNotification(null);
        }
        catch (IllegalArgumentException e) {
            execptionOccured = true;
        }
        Assertions.assertTrue((boolean)execptionOccured);
    }

    @Test
    public void testAddNotification_nonNotificationTx_assertTxNotAdded() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        Tx tx = TestUtils.makeMessage(TxMessageType.IMF, "1234", "", "", "", "gm2552@cerner.com");
        mgr.addNotification(tx);
        List addedAddr = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase("1234", Arrays.asList("gm2552@cerner.com".toUpperCase()));
        Assertions.assertEquals((int)0, (int)addedAddr.size());
    }

    @Test
    public void testAddNotification_noOrigMessageId_assertTxNotAdded() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        Tx tx = TestUtils.makeMessage(TxMessageType.DSN, "1234", "", "", "", "gm2552@cerner.com");
        mgr.addNotification(tx);
        List addedAddr = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase("1234", Arrays.asList("gm2552@cerner.com".toUpperCase()));
        Assertions.assertEquals((int)0, (int)addedAddr.size());
    }

    @Test
    public void testAddNotification_noFinalRecips_assertTxNotAdded() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        Tx tx = TestUtils.makeMessage(TxMessageType.DSN, "1234", "5678", "", "", "");
        mgr.addNotification(tx);
        List addedAddr = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase("1234", Arrays.asList("gm2552@cerner.com".toUpperCase()));
        Assertions.assertEquals((int)0, (int)addedAddr.size());
    }

    @Test
    public void testAddNotification_singleFinalRecipAdded_assertTxAdded() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        Tx tx = TestUtils.makeMessage(TxMessageType.DSN, "1234", "5678", "", "", "gm2552@cerner.com");
        mgr.addNotification(tx);
        List addedAddr = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase("5678", Arrays.asList("gm2552@cerner.com".toUpperCase()));
        Assertions.assertEquals((int)1, (int)addedAddr.size());
    }

    @Test
    public void testAddNotification_mulitpleFinalRecipAdded_assertTxAdded() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        mgr.setReceivedNotificationRepository(this.recRepo);
        Tx tx = TestUtils.makeMessage(TxMessageType.DSN, "1234", "5678", "", "", "gm2552@cerner.com,ah4626@cerner.com");
        mgr.addNotification(tx);
        List addedAddr = this.recRepo.findByMessageidIgnoreCaseAndAddressInIgnoreCase("5678", Arrays.asList("gm2552@cerner.com".toUpperCase(), "ah4626@cerner.com".toUpperCase()));
        Assertions.assertEquals((int)2, (int)addedAddr.size());
    }

    @Test
    public void testAddNotification_daoError_assertException() throws Exception {
        DefaultDuplicateNotificationStateManager mgr = new DefaultDuplicateNotificationStateManager();
        boolean execptionOccured = false;
        ReceivedNotificationRepository spyDao = (ReceivedNotificationRepository)Mockito.mock(ReceivedNotificationRepository.class);
        ((ReceivedNotificationRepository)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("")}).when((Object)spyDao)).save((Object)((ReceivedNotification)ArgumentMatchers.any()));
        mgr.setReceivedNotificationRepository(spyDao);
        try {
            Tx tx = TestUtils.makeMessage(TxMessageType.DSN, "1234", "5678", "", "", "gm2552@cerner.com,ah4626@cerner.com");
            mgr.addNotification(tx);
        }
        catch (DuplicateNotificationStateManagerException e) {
            execptionOccured = true;
        }
        Assertions.assertTrue((boolean)execptionOccured);
    }
}

