/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.processor;

import java.io.File;
import java.util.Properties;
import javax.mail.internet.MimeMessage;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nhindirect.common.mail.SMTPMailMessage;
import org.nhindirect.common.mail.streams.SMTPMailMessageConverter;
import org.nhindirect.monitor.TestApplication;
import org.nhindirect.monitor.processor.DSNMailSender;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.stream.binder.test.OutputDestination;
import org.springframework.cloud.stream.binder.test.TestChannelBinderConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.messaging.Message;

public class StreamsDSNMailSender_sendMailTest {
    @Test
    public void testSendMail_mailSent_messageSentAndReceived() throws Exception {
        Properties props = new Properties();
        props.load(FileUtils.openInputStream((File)new File("./src/test/resources/bootstrap.properties")));
        props.setProperty("direct.msgmonitor.dsnSender.useStreamsSender", "true");
        try (ConfigurableApplicationContext context = new SpringApplicationBuilder(TestChannelBinderConfiguration.getCompleteConfiguration((Class[])new Class[]{TestApplication.class})).properties(props).run(new String[]{""});){
            MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
            OutputDestination output = (OutputDestination)context.getBean(OutputDestination.class);
            DSNMailSender sender = (DSNMailSender)context.getBean(DSNMailSender.class);
            DefaultExchange exchange = new DefaultExchange((CamelContext)Mockito.mock(CamelContext.class));
            exchange.getIn().setBody((Object)msg);
            sender.sendMail((Exchange)exchange);
            Message streamMsg = output.receive();
            Assertions.assertNotNull((Object)streamMsg);
            SMTPMailMessage smtpMailMessage = SMTPMailMessageConverter.fromStreamMessage((Message)streamMsg);
            Assertions.assertNotNull((Object)smtpMailMessage);
            Assertions.assertEquals((Object)msg.getFrom()[0], (Object)smtpMailMessage.getMailFrom());
        }
    }
}

