/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.processor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nhindirect.common.mail.MailStandard;
import org.nhindirect.common.mail.dsn.DSNFailureTextBodyPartGenerator;
import org.nhindirect.common.mail.dsn.DSNGenerator;
import org.nhindirect.common.mail.dsn.impl.DefaultDSNFailureTextBodyPartGenerator;
import org.nhindirect.common.mail.dsn.impl.HumanReadableTextAssemblerFactory;
import org.nhindirect.common.tx.impl.DefaultTxDetailParser;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.condition.TxCompletionCondition;
import org.nhindirect.monitor.condition.impl.GeneralCompletionCondition;
import org.nhindirect.monitor.processor.DSNMessageGenerator;
import org.nhindirect.monitor.util.TestUtils;

public class DSNMessageGenerator_generateDSNFailureMessageTest {
    DSNMessageGenerator createGenerator() {
        DSNGenerator dsnGenerator = new DSNGenerator("Not Delivered:");
        GeneralCompletionCondition checker = new GeneralCompletionCondition();
        DefaultDSNFailureTextBodyPartGenerator textGenerator = new DefaultDSNFailureTextBodyPartGenerator("", "", "", "", "", HumanReadableTextAssemblerFactory.getInstance());
        return new DSNMessageGenerator(dsnGenerator, "postmaster", (TxCompletionCondition)checker, "JUnitMTA", (DSNFailureTextBodyPartGenerator)textGenerator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGenerateDSNFailureMessage_assertMessageCreated() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)Mockito.mock(CamelContext.class));
        String message = TestUtils.readMessageFromFile("MessageWithAttachment.txt");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        InputStream str = IOUtils.toInputStream((String)message);
        try {
            MimeMessage mimeMessage = new MimeMessage(null, str);
            mimeMessage.saveChanges();
            Map details = parser.getMessageDetails(mimeMessage);
            Tx originalMessage = new Tx(TxMessageType.IMF, details);
            ArrayList<Tx> txs = new ArrayList<Tx>();
            txs.add(originalMessage);
            DSNMessageGenerator generator = this.createGenerator();
            generator.generateDSNFailureMessage(txs, (Exchange)exchange);
            MimeMessage dsnMessage = (MimeMessage)exchange.getIn().getBody();
            Assertions.assertNotNull((Object)dsnMessage);
            String newSubject = MailStandard.getHeader((MimeMessage)dsnMessage, (String)"subject");
            Assertions.assertTrue((boolean)newSubject.contains(MailStandard.getHeader((MimeMessage)mimeMessage, (String)"subject")));
            String originalMessageId = MailStandard.getHeader((MimeMessage)dsnMessage, (String)"in-reply-to");
            Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)mimeMessage, (String)"message-id"), (Object)originalMessageId);
        }
        finally {
            IOUtils.closeQuietly((InputStream)str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGenerateDSNFailureMessage_assertMessageCreated_noCopiedSubject() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)Mockito.mock(CamelContext.class));
        String message = TestUtils.readMessageFromFile("MessageWithAttachment.txt");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        InputStream str = IOUtils.toInputStream((String)message);
        try {
            MimeMessage mimeMessage = new MimeMessage(null, str);
            mimeMessage.setHeader("subject", "");
            mimeMessage.saveChanges();
            Map details = parser.getMessageDetails(mimeMessage);
            Tx originalMessage = new Tx(TxMessageType.IMF, details);
            ArrayList<Tx> txs = new ArrayList<Tx>();
            txs.add(originalMessage);
            DSNMessageGenerator generator = this.createGenerator();
            generator.generateDSNFailureMessage(txs, (Exchange)exchange);
            MimeMessage dsnMessage = (MimeMessage)exchange.getIn().getBody();
            Assertions.assertNotNull((Object)dsnMessage);
            String newSubject = MailStandard.getHeader((MimeMessage)dsnMessage, (String)"subject");
            Assertions.assertEquals((Object)"Not Delivered:", (Object)newSubject);
        }
        finally {
            IOUtils.closeQuietly((InputStream)str);
        }
    }

    @Test
    public void testGenerateDSNFailureMessage_noFrom_assertException() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)Mockito.mock(CamelContext.class));
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "", "gm2552@direct.securehealthemail.com", "");
        ArrayList<Tx> txs = new ArrayList<Tx>();
        txs.add(originalMessage);
        DSNMessageGenerator generator = this.createGenerator();
        boolean exceptionOccurred = false;
        try {
            generator.generateDSNFailureMessage(txs, (Exchange)exchange);
        }
        catch (MessagingException e) {
            exceptionOccurred = true;
        }
        Assertions.assertTrue((boolean)exceptionOccurred);
    }

    @Test
    public void testGenerateDSNFailureMessage_nullMessageToTrack() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)Mockito.mock(CamelContext.class));
        ArrayList txs = new ArrayList();
        DSNMessageGenerator generator = this.createGenerator();
        generator.generateDSNFailureMessage(txs, (Exchange)exchange);
        MimeMessage dsnMessage = (MimeMessage)exchange.getIn().getBody();
        Assertions.assertNull((Object)dsnMessage);
    }

    @Test
    public void testGenerateDSNFailureMessage_noIncompleteRecipients() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)Mockito.mock(CamelContext.class));
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com");
        ArrayList<Tx> txs = new ArrayList<Tx>();
        txs.add(originalMessage);
        txs.add(mdnMessage);
        DSNMessageGenerator generator = this.createGenerator();
        generator.generateDSNFailureMessage(txs, (Exchange)exchange);
        MimeMessage dsnMessage = (MimeMessage)exchange.getIn().getBody();
        Assertions.assertNull((Object)dsnMessage);
    }
}

