/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.processor;

import java.io.IOException;
import java.io.StringWriter;
import javax.mail.internet.MimeMessage;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.apache.commons.net.smtp.SMTPClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.monitor.processor.SMTPClientFactory;
import org.nhindirect.monitor.processor.SMTPDSNMailSender;
import org.nhindirect.monitor.util.TestUtils;

public class DSNMailSender_sendMailTest {
    protected SMTPClientFactory createFactory(final SMTPClient client) {
        SMTPClientFactory factory = new SMTPClientFactory(){

            public SMTPClient createInstance() {
                return client;
            }
        };
        return factory;
    }

    @Test
    public void testSendMail_mailSent_noExceptions() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        SMTPClient client = (SMTPClient)Mockito.mock(SMTPClient.class);
        Mockito.when((Object)client.setSender((String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)client.addRecipient((String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)client.sendMessageData()).thenReturn((Object)new StringWriter());
        Mockito.when((Object)client.getReplyCode()).thenReturn((Object)250);
        SMTPClientFactory factory = this.createFactory(client);
        SMTPDSNMailSender sender = new SMTPDSNMailSender("smtp://localhost", factory);
        DefaultExchange exchange = new DefaultExchange((CamelContext)Mockito.mock(CamelContext.class));
        exchange.getIn().setBody((Object)msg);
        sender.sendMail((Exchange)exchange);
        ((SMTPClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).getReplyCode();
    }

    @Test
    public void testSendMail_nullGateway() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)Mockito.mock(CamelContext.class));
        SMTPDSNMailSender sender = new SMTPDSNMailSender();
        boolean exceptionOccurred = false;
        try {
            sender.sendMail((Exchange)exchange);
        }
        catch (IllegalStateException e) {
            exceptionOccurred = true;
        }
        Assertions.assertTrue((boolean)exceptionOccurred);
    }

    @Test
    public void testSendMail_emptyGateway() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)Mockito.mock(CamelContext.class));
        SMTPDSNMailSender sender = new SMTPDSNMailSender("", null);
        boolean exceptionOccurred = false;
        try {
            sender.sendMail((Exchange)exchange);
        }
        catch (IllegalStateException e) {
            exceptionOccurred = true;
        }
        Assertions.assertTrue((boolean)exceptionOccurred);
    }

    @Test
    public void testSendMail_emptyFactory() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)Mockito.mock(CamelContext.class));
        SMTPDSNMailSender sender = new SMTPDSNMailSender("smtp://localhost", null);
        boolean exceptionOccurred = false;
        try {
            sender.sendMail((Exchange)exchange);
        }
        catch (IllegalStateException e) {
            exceptionOccurred = true;
        }
        Assertions.assertTrue((boolean)exceptionOccurred);
    }

    @Test
    public void testSendMail_setSenderError_assertException() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        SMTPClient client = (SMTPClient)Mockito.mock(SMTPClient.class);
        Mockito.when((Object)client.setSender((String)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)client.addRecipient((String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)client.sendMessageData()).thenReturn((Object)new StringWriter());
        Mockito.when((Object)client.getReplyCode()).thenReturn((Object)250);
        SMTPClientFactory factory = this.createFactory(client);
        SMTPDSNMailSender sender = new SMTPDSNMailSender("smtp://localhost", factory);
        DefaultExchange exchange = new DefaultExchange((CamelContext)Mockito.mock(CamelContext.class));
        exchange.getIn().setBody((Object)msg);
        boolean exceptionOccurred = false;
        try {
            sender.sendMail((Exchange)exchange);
        }
        catch (IOException e) {
            exceptionOccurred = true;
        }
        Assertions.assertTrue((boolean)exceptionOccurred);
        ((SMTPClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).setSender((String)ArgumentMatchers.any());
        ((SMTPClient)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).addRecipient((String)ArgumentMatchers.any());
    }

    @Test
    public void testSendMail_setAddRecip_assertException() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        SMTPClient client = (SMTPClient)Mockito.mock(SMTPClient.class);
        Mockito.when((Object)client.setSender((String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)client.addRecipient((String)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)client.sendMessageData()).thenReturn((Object)new StringWriter());
        Mockito.when((Object)client.getReplyCode()).thenReturn((Object)250);
        SMTPClientFactory factory = this.createFactory(client);
        SMTPDSNMailSender sender = new SMTPDSNMailSender("smtp://localhost", factory);
        DefaultExchange exchange = new DefaultExchange((CamelContext)Mockito.mock(CamelContext.class));
        exchange.getIn().setBody((Object)msg);
        boolean exceptionOccurred = false;
        try {
            sender.sendMail((Exchange)exchange);
        }
        catch (IOException e) {
            exceptionOccurred = true;
        }
        Assertions.assertTrue((boolean)exceptionOccurred);
        ((SMTPClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).addRecipient((String)ArgumentMatchers.any());
        ((SMTPClient)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).sendMessageData();
    }

    @Test
    public void testSendMail_nullWriter_assertException() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        SMTPClient client = (SMTPClient)Mockito.mock(SMTPClient.class);
        Mockito.when((Object)client.setSender((String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)client.addRecipient((String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)client.sendMessageData()).thenReturn(null);
        Mockito.when((Object)client.getReplyCode()).thenReturn((Object)250);
        SMTPClientFactory factory = this.createFactory(client);
        SMTPDSNMailSender sender = new SMTPDSNMailSender("smtp://localhost", factory);
        DefaultExchange exchange = new DefaultExchange((CamelContext)Mockito.mock(CamelContext.class));
        exchange.getIn().setBody((Object)msg);
        boolean exceptionOccurred = false;
        try {
            sender.sendMail((Exchange)exchange);
        }
        catch (IOException e) {
            exceptionOccurred = true;
        }
        Assertions.assertTrue((boolean)exceptionOccurred);
        ((SMTPClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).sendMessageData();
        ((SMTPClient)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).completePendingCommand();
    }

    @Test
    public void testSendMail_failureStatusCode_assertException() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        SMTPClient client = (SMTPClient)Mockito.mock(SMTPClient.class);
        Mockito.when((Object)client.setSender((String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)client.addRecipient((String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)client.sendMessageData()).thenReturn((Object)new StringWriter());
        Mockito.when((Object)client.getReplyCode()).thenReturn((Object)300);
        SMTPClientFactory factory = this.createFactory(client);
        SMTPDSNMailSender sender = new SMTPDSNMailSender("smtp://localhost", factory);
        DefaultExchange exchange = new DefaultExchange((CamelContext)Mockito.mock(CamelContext.class));
        exchange.getIn().setBody((Object)msg);
        boolean exceptionOccurred = false;
        try {
            sender.sendMail((Exchange)exchange);
        }
        catch (IOException e) {
            exceptionOccurred = true;
        }
        Assertions.assertTrue((boolean)exceptionOccurred);
        ((SMTPClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)2))).getReplyCode();
    }
}

