/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.processor;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.monitor.processor.SMTPClientFactory;
import org.nhindirect.monitor.processor.SMTPDSNMailSender;

public class DSNMailSender_constructorTest {
    @Test
    public void testContrust_defaultConstructor() {
        SMTPDSNMailSender sender = new SMTPDSNMailSender();
        Assertions.assertNull((Object)sender.gatewayHost);
        Assertions.assertNull((Object)sender.clientFactory);
        Assertions.assertEquals((int)25, (int)sender.gatewayPort);
    }

    @Test
    public void testContrust_parameterizedConstructor() {
        SMTPClientFactory factory = new SMTPClientFactory();
        SMTPDSNMailSender sender = new SMTPDSNMailSender("smtp://localhost", factory);
        Assertions.assertEquals((Object)"localhost", (Object)sender.gatewayHost);
        Assertions.assertEquals((Object)factory, (Object)sender.clientFactory);
        Assertions.assertEquals((int)25, (int)sender.gatewayPort);
    }

    @Test
    public void testContrust_parameterizedConstructor_customPort() {
        SMTPClientFactory factory = new SMTPClientFactory();
        SMTPDSNMailSender sender = new SMTPDSNMailSender("smtp://localhost:10026", factory);
        Assertions.assertEquals((Object)"localhost", (Object)sender.gatewayHost);
        Assertions.assertEquals((Object)factory, (Object)sender.clientFactory);
        Assertions.assertEquals((int)10026, (int)sender.gatewayPort);
    }

    @Test
    public void testContrust_parameterizedConstructor_invaludURL() {
        SMTPClientFactory factory = new SMTPClientFactory();
        boolean exceptionOccured = false;
        try {
            new SMTPDSNMailSender("smtpewdf://localhost\\:10026", factory);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

