/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.expression;

import java.util.HashMap;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.expression.MessageIdCorrelationExpression;

public class MessageIdCorrelationExpression_evaluateTest {
    @Test
    public void testEvaluate_emptyDetails_assertNullId() {
        MessageIdCorrelationExpression exp = new MessageIdCorrelationExpression();
        Tx tx = new Tx(TxMessageType.IMF, new HashMap());
        CamelContext context = (CamelContext)Mockito.mock(CamelContext.class);
        DefaultExchange exchange = new DefaultExchange(context);
        exchange.getIn().setBody((Object)tx);
        Assertions.assertNull((Object)exp.evaluate((Exchange)exchange, String.class));
    }

    @Test
    public void testEvaluate_IMFMessage_noMsgId_assertNullId() {
        MessageIdCorrelationExpression exp = new MessageIdCorrelationExpression();
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        details.put(TxDetailType.FROM.getType(), new TxDetail(TxDetailType.FROM, "me@test.com"));
        Tx tx = new Tx(TxMessageType.IMF, details);
        CamelContext context = (CamelContext)Mockito.mock(CamelContext.class);
        DefaultExchange exchange = new DefaultExchange(context);
        exchange.getIn().setBody((Object)tx);
        Assertions.assertNull((Object)exp.evaluate((Exchange)exchange, String.class));
    }

    @Test
    public void testEvaluate_IMFMessage_msgIdExists_assertMessageIdEvaluated() {
        MessageIdCorrelationExpression exp = new MessageIdCorrelationExpression();
        String msgId = UUID.randomUUID().toString();
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        details.put(TxDetailType.MSG_ID.getType(), new TxDetail(TxDetailType.MSG_ID, msgId));
        Tx tx = new Tx(TxMessageType.IMF, details);
        CamelContext context = (CamelContext)Mockito.mock(CamelContext.class);
        DefaultExchange exchange = new DefaultExchange(context);
        exchange.getIn().setBody((Object)tx);
        Assertions.assertEquals((Object)msgId, (Object)exp.evaluate((Exchange)exchange, String.class));
    }

    @Test
    public void testEvaluate_MDNMessage_noParentMsgId_assertNullId() {
        MessageIdCorrelationExpression exp = new MessageIdCorrelationExpression();
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        details.put(TxDetailType.FROM.getType(), new TxDetail(TxDetailType.FROM, "me@test.com"));
        Tx tx = new Tx(TxMessageType.MDN, details);
        CamelContext context = (CamelContext)Mockito.mock(CamelContext.class);
        DefaultExchange exchange = new DefaultExchange(context);
        exchange.getIn().setBody((Object)tx);
        Assertions.assertNull((Object)exp.evaluate((Exchange)exchange, String.class));
    }

    @Test
    public void testEvaluate_DNSMessage_noParentMsgId_assertNullId() {
        MessageIdCorrelationExpression exp = new MessageIdCorrelationExpression();
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        details.put(TxDetailType.FROM.getType(), new TxDetail(TxDetailType.FROM, "me@test.com"));
        Tx tx = new Tx(TxMessageType.MDN, details);
        CamelContext context = (CamelContext)Mockito.mock(CamelContext.class);
        DefaultExchange exchange = new DefaultExchange(context);
        exchange.getIn().setBody((Object)tx);
        Assertions.assertNull((Object)exp.evaluate((Exchange)exchange, String.class));
    }

    @Test
    public void testEvaluate_MDNMessage_parentMsgIdExists_assertMessageIdEvaluated() {
        MessageIdCorrelationExpression exp = new MessageIdCorrelationExpression();
        String msgId = UUID.randomUUID().toString();
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        details.put(TxDetailType.PARENT_MSG_ID.getType(), new TxDetail(TxDetailType.PARENT_MSG_ID, msgId));
        Tx tx = new Tx(TxMessageType.MDN, details);
        CamelContext context = (CamelContext)Mockito.mock(CamelContext.class);
        DefaultExchange exchange = new DefaultExchange(context);
        exchange.getIn().setBody((Object)tx);
        Assertions.assertEquals((Object)msgId, (Object)exp.evaluate((Exchange)exchange, String.class));
    }

    @Test
    public void testEvaluate_DSNMessage_parentMsgIdExists_assertMessageIdEvaluated() {
        MessageIdCorrelationExpression exp = new MessageIdCorrelationExpression();
        String msgId = UUID.randomUUID().toString();
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        details.put(TxDetailType.PARENT_MSG_ID.getType(), new TxDetail(TxDetailType.PARENT_MSG_ID, msgId));
        Tx tx = new Tx(TxMessageType.DSN, details);
        CamelContext context = (CamelContext)Mockito.mock(CamelContext.class);
        DefaultExchange exchange = new DefaultExchange(context);
        exchange.getIn().setBody((Object)tx);
        Assertions.assertEquals((Object)msgId, (Object)exp.evaluate((Exchange)exchange, String.class));
    }
}

