/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.distributedaggregatorroute;

import java.util.List;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.SpringBaseTest;
import org.nhindirect.monitor.repository.AggregationCompletedRepository;
import org.nhindirect.monitor.repository.AggregationRepository;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(locations={"classpath:properties/recoveryMonitor.properties"}, properties={"camel.springboot.xmlRoutes=classpath:distributedAggregatorRoutes/recover-exchange-to-mock.xml"})
public class TestRecoveryMonitorRoute
extends SpringBaseTest {
    @Autowired
    protected CamelContext context;
    @Autowired
    private AggregationRepository aggRepo;
    @Autowired
    private AggregationCompletedRepository aggCompRepo;
    @Autowired
    private RecoverableAggregationRepository repo;
    protected MockEndpoint mock;
    protected ProducerTemplate template;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.aggRepo.deleteAll();
        this.aggCompRepo.deleteAll();
        this.mock = (MockEndpoint)this.context.getEndpoint("mock:result");
        this.mock.reset();
        this.template = this.context.createProducerTemplate();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com,ah4626@direct.securehealthemail.com", "");
        DefaultExchange exchange = new DefaultExchange(this.context);
        exchange.getIn().setBody((Object)originalMessage);
        this.repo.add(this.context, originalMessageId, (Exchange)exchange);
        this.repo.remove(this.context, originalMessageId, (Exchange)exchange);
        this.repo.recover(this.context, exchange.getExchangeId());
    }

    @Test
    public void testRecoverFromRepository() throws Exception {
        boolean exchangeFound = false;
        List exchanges = null;
        for (int cnt = 0; cnt < 10; ++cnt) {
            exchanges = this.mock.getReceivedExchanges();
            if (exchanges.size() == 1) {
                exchangeFound = true;
                break;
            }
            Thread.sleep(2000L);
        }
        Assertions.assertTrue((boolean)exchangeFound);
        Tx originalMessage = (Tx)((Exchange)exchanges.iterator().next()).getIn().getBody();
        Assertions.assertEquals((Object)"gm2552@cerner.com", (Object)originalMessage.getDetail(TxDetailType.FROM).getDetailValue());
        AggregationRepository aggRepo = (AggregationRepository)this.context.getRegistry().lookupByType(AggregationRepository.class).values().iterator().next();
        AggregationCompletedRepository aggCompRepo = (AggregationCompletedRepository)this.context.getRegistry().lookupByType(AggregationCompletedRepository.class).values().iterator().next();
        Assertions.assertEquals((int)0, (int)aggRepo.findAllKeys().size());
        Assertions.assertEquals((int)0, (int)aggCompRepo.findAllKeys().size());
    }
}

