/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.distributedaggregatorroute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.SpringBaseTest;
import org.nhindirect.monitor.repository.AggregationCompletedRepository;
import org.nhindirect.monitor.repository.AggregationRepository;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.TestPropertySource;

@TestPropertySource(properties={"camel.springboot.xmlRoutes=classpath:distributedAggregatorRoutes/multithreaded-route-to-mock.xml"})
public class TestMultithreadedAddUpdateFailureMonitoringRoute
extends SpringBaseTest {
    @Autowired
    protected CamelContext context;
    @Autowired
    private AggregationRepository aggRepo;
    @Autowired
    private AggregationCompletedRepository aggCompRepo;
    protected MockEndpoint mock;
    protected ProducerTemplate template;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.aggRepo.deleteAll();
        this.aggCompRepo.deleteAll();
        this.mock = (MockEndpoint)this.context.getEndpoint("mock:result");
        this.mock.reset();
        this.template = this.context.createProducerTemplate();
    }

    @Test
    public void testMultithreadedMDNResponseHandling_assertAllMDNsHandled() throws Exception {
        StringBuilder recipBuilder = new StringBuilder();
        ArrayList<String> recips = new ArrayList<String>();
        for (int i = 0; i < 100; ++i) {
            String recip = "recip" + (i + 1) + "@test.com";
            recips.add(recip);
            recipBuilder.append(recip);
            if (i == 99) continue;
            recipBuilder.append(",");
        }
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", recipBuilder.toString(), "");
        this.template.sendBody("seda:start", (Object)originalMessage);
        for (String recip : recips) {
            Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, recip, "gm2552@cerner.com", recip);
            this.template.sendBody("seda:start", (Object)mdnMessage);
        }
        boolean exchangeFound = false;
        List exchanges = null;
        for (int cnt = 0; cnt < 10; ++cnt) {
            exchanges = this.mock.getReceivedExchanges();
            if (exchanges.size() == 1) {
                exchangeFound = true;
                break;
            }
            Thread.sleep(2000L);
        }
        Assertions.assertTrue((boolean)exchangeFound);
        Collection exBody = (Collection)((Exchange)exchanges.iterator().next()).getIn().getBody();
        Assertions.assertEquals((int)101, (int)exBody.size());
    }
}

