/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.condition.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.monitor.condition.TxTimeoutCondition;
import org.nhindirect.monitor.condition.impl.VariableTimeoutCondition;

public class VariableTimeoutCondition_getTimeoutTest {
    @Test
    public void testGetTimeoutTest_nullMessageToTrack_assertUsesGeneralCondtion() {
        TxTimeoutCondition timelyCond = (TxTimeoutCondition)Mockito.mock(TxTimeoutCondition.class);
        TxTimeoutCondition generalCond = (TxTimeoutCondition)Mockito.mock(TxTimeoutCondition.class);
        VariableTimeoutCondition cond = new VariableTimeoutCondition(timelyCond, generalCond);
        VariableTimeoutCondition spy = (VariableTimeoutCondition)Mockito.spy((Object)cond);
        Mockito.when((Object)spy.getMessageToTrack((Collection)ArgumentMatchers.any())).thenReturn(null);
        Assertions.assertEquals((long)0L, (long)spy.getTimeout(new ArrayList(), 1000L));
        ((TxTimeoutCondition)Mockito.verify((Object)timelyCond, (VerificationMode)Mockito.never())).getTimeout((Collection)((ArrayList)ArgumentMatchers.any()), ArgumentMatchers.eq((long)1000L));
        ((TxTimeoutCondition)Mockito.verify((Object)generalCond, (VerificationMode)Mockito.times((int)1))).getTimeout((Collection)((ArrayList)ArgumentMatchers.any()), ArgumentMatchers.eq((long)1000L));
    }

    @Test
    public void testGetTimeoutTest_nonTimelyMessage_assertUsesGeneralCondtion() {
        TxTimeoutCondition timelyCond = (TxTimeoutCondition)Mockito.mock(TxTimeoutCondition.class);
        TxTimeoutCondition generalCond = (TxTimeoutCondition)Mockito.mock(TxTimeoutCondition.class);
        VariableTimeoutCondition cond = new VariableTimeoutCondition(timelyCond, generalCond);
        VariableTimeoutCondition spy = (VariableTimeoutCondition)Mockito.spy((Object)cond);
        Tx tx = (Tx)Mockito.mock(Tx.class);
        Mockito.when((Object)spy.getMessageToTrack((Collection)ArgumentMatchers.any())).thenReturn((Object)tx);
        Mockito.when((Object)spy.isRelAndTimelyRequired((Tx)ArgumentMatchers.any())).thenReturn((Object)false);
        Assertions.assertEquals((long)0L, (long)spy.getTimeout(new ArrayList(), 1000L));
        ((TxTimeoutCondition)Mockito.verify((Object)timelyCond, (VerificationMode)Mockito.never())).getTimeout((Collection)((ArrayList)ArgumentMatchers.any()), ArgumentMatchers.eq((long)1000L));
        ((TxTimeoutCondition)Mockito.verify((Object)generalCond, (VerificationMode)Mockito.times((int)1))).getTimeout((Collection)((ArrayList)ArgumentMatchers.any()), ArgumentMatchers.eq((long)1000L));
    }

    @Test
    public void testGetTimeoutTest_timelyMessage_assertUsesTimelyCondtion() {
        TxTimeoutCondition timelyCond = (TxTimeoutCondition)Mockito.mock(TxTimeoutCondition.class);
        TxTimeoutCondition generalCond = (TxTimeoutCondition)Mockito.mock(TxTimeoutCondition.class);
        VariableTimeoutCondition cond = new VariableTimeoutCondition(timelyCond, generalCond);
        VariableTimeoutCondition spy = (VariableTimeoutCondition)Mockito.spy((Object)cond);
        Tx tx = (Tx)Mockito.mock(Tx.class);
        Mockito.when((Object)spy.getMessageToTrack((Collection)ArgumentMatchers.any())).thenReturn((Object)tx);
        Mockito.when((Object)spy.isRelAndTimelyRequired((Tx)ArgumentMatchers.any())).thenReturn((Object)true);
        Assertions.assertEquals((long)0L, (long)spy.getTimeout(new ArrayList(), 1000L));
        ((TxTimeoutCondition)Mockito.verify((Object)timelyCond, (VerificationMode)Mockito.times((int)1))).getTimeout((Collection)((ArrayList)ArgumentMatchers.any()), ArgumentMatchers.eq((long)1000L));
        ((TxTimeoutCondition)Mockito.verify((Object)generalCond, (VerificationMode)Mockito.never())).getTimeout((Collection)((ArrayList)ArgumentMatchers.any()), ArgumentMatchers.eq((long)1000L));
    }
}

