/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.condition.impl;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.condition.TxCompletionCondition;
import org.nhindirect.monitor.condition.impl.VariableCompletionCondition;

public class VariableCompletionCondition_isTimelyAndRequiredTest {
    @Test
    public void testIsTimelyAndRequired_nullMessage_assertFalse() {
        TxCompletionCondition cond1 = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        TxCompletionCondition cond2 = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        VariableCompletionCondition cond = new VariableCompletionCondition(cond1, cond2);
        Assertions.assertFalse((boolean)cond.isRelAndTimelyRequired(null));
    }

    @Test
    public void testIsTimelyAndRequired_emptyDetails_assertFalse() {
        TxCompletionCondition cond1 = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        TxCompletionCondition cond2 = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        VariableCompletionCondition cond = new VariableCompletionCondition(cond1, cond2);
        Tx msg = new Tx(TxMessageType.IMF, new HashMap());
        Assertions.assertFalse((boolean)cond.isRelAndTimelyRequired(msg));
    }

    @Test
    public void testIsTimelyAndRequired_NoMNDOptionDetails_assertFalse() {
        TxCompletionCondition cond1 = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        TxCompletionCondition cond2 = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        VariableCompletionCondition cond = new VariableCompletionCondition(cond1, cond2);
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        details.put(TxDetailType.FROM.getType(), new TxDetail(TxDetailType.FROM, "me@test.com"));
        Tx msg = new Tx(TxMessageType.IMF, details);
        Assertions.assertFalse((boolean)cond.isRelAndTimelyRequired(msg));
    }

    @Test
    public void testIsTimelyAndRequired_MDNOptionNotForTimely_assertFalse() {
        TxCompletionCondition cond1 = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        TxCompletionCondition cond2 = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        VariableCompletionCondition cond = new VariableCompletionCondition(cond1, cond2);
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        details.put(TxDetailType.DISPOSITION_OPTIONS.getType(), new TxDetail(TxDetailType.DISPOSITION_OPTIONS, "X-NOT-TIMELY"));
        Tx msg = new Tx(TxMessageType.IMF, details);
        Assertions.assertFalse((boolean)cond.isRelAndTimelyRequired(msg));
    }

    @Test
    public void testIsTimelyAndRequired_MDNOptionForTimely_assertTrue() {
        TxCompletionCondition cond1 = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        TxCompletionCondition cond2 = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        VariableCompletionCondition cond = new VariableCompletionCondition(cond1, cond2);
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        details.put(TxDetailType.DISPOSITION_OPTIONS.getType(), new TxDetail(TxDetailType.DISPOSITION_OPTIONS, "X-DIRECT-FINAL-DESTINATION-DELIVERY"));
        Tx msg = new Tx(TxMessageType.IMF, details);
        Assertions.assertTrue((boolean)cond.isRelAndTimelyRequired(msg));
    }
}

