/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.condition.impl;

import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.monitor.condition.TxCompletionCondition;
import org.nhindirect.monitor.condition.impl.VariableCompletionCondition;

public class VariableCompletionCondition_isCompleteTest {
    @Test
    public void testIsComplete_nullMessageToTrack_assertNull() {
        TxCompletionCondition cond1 = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        TxCompletionCondition cond2 = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        VariableCompletionCondition cond = new VariableCompletionCondition(cond1, cond2);
        VariableCompletionCondition spy = (VariableCompletionCondition)Mockito.spy((Object)cond);
        Mockito.when((Object)spy.getMessageToTrackInternal((Collection)ArgumentMatchers.any())).thenReturn(null);
        Assertions.assertFalse((boolean)spy.isComplete(null));
    }

    @Test
    public void testIsComplete_isTimely_assertComplete() {
        TxCompletionCondition timelyCond = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        Mockito.when((Object)timelyCond.isComplete((Collection)ArgumentMatchers.any())).thenReturn((Object)true);
        TxCompletionCondition generalCond = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        VariableCompletionCondition cond = new VariableCompletionCondition(timelyCond, generalCond);
        VariableCompletionCondition spy = (VariableCompletionCondition)Mockito.spy((Object)cond);
        Tx msgToTrack = (Tx)Mockito.mock(Tx.class);
        Mockito.when((Object)spy.getMessageToTrackInternal((Collection)ArgumentMatchers.any())).thenReturn((Object)msgToTrack);
        Mockito.when((Object)spy.isRelAndTimelyRequired((Tx)ArgumentMatchers.any())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)spy.isComplete(null));
        ((TxCompletionCondition)Mockito.verify((Object)timelyCond, (VerificationMode)Mockito.times((int)1))).isComplete((Collection)ArgumentMatchers.any());
        ((TxCompletionCondition)Mockito.verify((Object)generalCond, (VerificationMode)Mockito.never())).isComplete((Collection)ArgumentMatchers.any());
    }

    @Test
    public void testIsComplete_isTimely_assertNotComplete() {
        TxCompletionCondition timelyCond = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        TxCompletionCondition generalCond = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        Mockito.when((Object)generalCond.isComplete((Collection)ArgumentMatchers.any())).thenReturn((Object)true);
        VariableCompletionCondition cond = new VariableCompletionCondition(timelyCond, generalCond);
        VariableCompletionCondition spy = (VariableCompletionCondition)Mockito.spy((Object)cond);
        Tx msgToTrack = (Tx)Mockito.mock(Tx.class);
        Mockito.when((Object)spy.getMessageToTrackInternal((Collection)ArgumentMatchers.any())).thenReturn((Object)msgToTrack);
        Mockito.when((Object)spy.isRelAndTimelyRequired((Tx)ArgumentMatchers.any())).thenReturn((Object)true);
        Assertions.assertFalse((boolean)spy.isComplete(null));
        ((TxCompletionCondition)Mockito.verify((Object)timelyCond, (VerificationMode)Mockito.times((int)1))).isComplete((Collection)ArgumentMatchers.any());
        ((TxCompletionCondition)Mockito.verify((Object)generalCond, (VerificationMode)Mockito.never())).isComplete((Collection)ArgumentMatchers.any());
    }

    @Test
    public void testIsComplete_isNotTimely_assertComplete() {
        TxCompletionCondition timelyCond = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        TxCompletionCondition generalCond = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        Mockito.when((Object)generalCond.isComplete((Collection)ArgumentMatchers.any())).thenReturn((Object)true);
        VariableCompletionCondition cond = new VariableCompletionCondition(timelyCond, generalCond);
        VariableCompletionCondition spy = (VariableCompletionCondition)Mockito.spy((Object)cond);
        Tx msgToTrack = (Tx)Mockito.mock(Tx.class);
        Mockito.when((Object)spy.getMessageToTrackInternal((Collection)ArgumentMatchers.any())).thenReturn((Object)msgToTrack);
        Mockito.when((Object)spy.isRelAndTimelyRequired((Tx)ArgumentMatchers.any())).thenReturn((Object)false);
        Assertions.assertTrue((boolean)spy.isComplete(null));
        ((TxCompletionCondition)Mockito.verify((Object)timelyCond, (VerificationMode)Mockito.never())).isComplete((Collection)ArgumentMatchers.any());
        ((TxCompletionCondition)Mockito.verify((Object)generalCond, (VerificationMode)Mockito.times((int)1))).isComplete((Collection)ArgumentMatchers.any());
    }

    @Test
    public void testIsComplete_isNotTimely_assertNotComplete() {
        TxCompletionCondition timelyCond = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        Mockito.when((Object)timelyCond.isComplete((Collection)ArgumentMatchers.any())).thenReturn((Object)true);
        TxCompletionCondition generalCond = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        VariableCompletionCondition cond = new VariableCompletionCondition(timelyCond, generalCond);
        VariableCompletionCondition spy = (VariableCompletionCondition)Mockito.spy((Object)cond);
        Tx msgToTrack = (Tx)Mockito.mock(Tx.class);
        Mockito.when((Object)spy.getMessageToTrackInternal((Collection)ArgumentMatchers.any())).thenReturn((Object)msgToTrack);
        Mockito.when((Object)spy.isRelAndTimelyRequired((Tx)ArgumentMatchers.any())).thenReturn((Object)false);
        Assertions.assertFalse((boolean)spy.isComplete(null));
        ((TxCompletionCondition)Mockito.verify((Object)timelyCond, (VerificationMode)Mockito.never())).isComplete((Collection)ArgumentMatchers.any());
        ((TxCompletionCondition)Mockito.verify((Object)generalCond, (VerificationMode)Mockito.times((int)1))).isComplete((Collection)ArgumentMatchers.any());
    }
}

