/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.condition.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.mail.dsn.DSNStandard;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.condition.impl.TimelyAndReliableCompletionCondition;
import org.nhindirect.monitor.util.TestUtils;

public class TimelyAndReliableCompletionCondition_isCompleteTest {
    @Test
    public void testIsComplete_nullTxs_assertFalse() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        Assertions.assertFalse((boolean)condition.isComplete(null));
    }

    @Test
    public void testIsComplete_nullEmptyTx_assertFalse() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        Assertions.assertFalse((boolean)condition.isComplete(new ArrayList()));
    }

    @Test
    public void testIsComplete_noMessageToTrack_assertFalse() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        Tx tx = new Tx(TxMessageType.DSN, new HashMap());
        List<Tx> txs = Arrays.asList(tx);
        Assertions.assertFalse((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_noFinalRecips_assertFalse() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        String msgId = UUID.randomUUID().toString();
        details.put(TxDetailType.MSG_ID.getType(), new TxDetail(TxDetailType.MSG_ID, msgId));
        Tx tx = new Tx(TxMessageType.IMF, details);
        List<Tx> txs = Arrays.asList(tx);
        Assertions.assertFalse((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_MDNDispotionNull_assertFalse() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeReliableMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertFalse((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_FinalRecipNull_assertFalse() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeReliableMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "", "", "processed");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertFalse((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_MDNDispatched_nullOptionsHeader_assertFalse() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "dispatched");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertFalse((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_MDNDispatched_nonReliableDispotionOption_assertFalse() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "dispatched", "X-NON-RELIABLEs");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertFalse((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_noDSNAction_assertFalse() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.DSN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertFalse((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_nonFailedDSNAction_assertFalse() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.DSN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", DSNStandard.DSNAction.DELAYED.toString(), "");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertFalse((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_failedDSNAction_finalRecipNotInOriginalMessage_assertFalse() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.DSN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "me@test.com", DSNStandard.DSNAction.FAILED.toString(), "");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertFalse((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_failedDSNAction_assertTrue() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.DSN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", DSNStandard.DSNAction.FAILED.toString(), "");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertTrue((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_failedDSNAction_plusNotationOnDSNRecip_rfc822NotactionOnFinalRecip_assertTrue() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.DSN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552+readrecipt@cerner.com", "rfc822; gm2552@direct.securehealthemail.com", DSNStandard.DSNAction.FAILED.toString(), "");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertTrue((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_completedMDNs_assertTrue() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnProcessedMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "processed", "");
        Tx mdnDispatchedMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "", "dispatched", "X-DIRECT-FINAL-DESTINATION-DELIVERY");
        List<Tx> txs = Arrays.asList(originalMessage, mdnProcessedMessage, mdnDispatchedMessage);
        Assertions.assertTrue((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_completedMDNs_plusNotationOnDSNRecip_rfc822NotactionOnFinalRecip_assertTrue() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnProcessedMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552+readrecipt@cerner.com", "rfc822; gm2552@direct.securehealthemail.com", "", "processed", "");
        Tx mdnDispatchedMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552+readrecipt@cerner.com", "rfc822; gm2552@direct.securehealthemail.com", "", "dispatched", "X-DIRECT-FINAL-DESTINATION-DELIVERY");
        List<Tx> txs = Arrays.asList(originalMessage, mdnProcessedMessage, mdnDispatchedMessage);
        Assertions.assertTrue((boolean)condition.isComplete(txs));
    }
}

