/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.condition.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.condition.impl.TimelyAndReliableCompletionCondition;
import org.nhindirect.monitor.util.TestUtils;

public class TimelyAndReliableCompletionCondition_getIncompleteRecipientsEmptyTxsTest {
    @Test
    public void testIsComplete_nullTxs_assertEmptyList() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        Collection recips = condition.getIncompleteRecipients(null);
        Assertions.assertEquals((int)0, (int)recips.size());
    }

    @Test
    public void testIsComplete_nullTxs_emptyTxs() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        Collection recips = condition.getIncompleteRecipients(new ArrayList());
        Assertions.assertEquals((int)0, (int)recips.size());
    }

    @Test
    public void testIsComplete_noMessageToTrack_emptyTxs() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.DSN, "", UUID.randomUUID().toString(), "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        ArrayList<Tx> txs = new ArrayList<Tx>();
        txs.add(originalMessage);
        Collection recips = condition.getIncompleteRecipients(txs);
        Assertions.assertEquals((int)0, (int)recips.size());
    }

    @Test
    public void testIsComplete_noRecips_emptyTxs() {
        TimelyAndReliableCompletionCondition condition = new TimelyAndReliableCompletionCondition();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, "", UUID.randomUUID().toString(), "gm2552@cerner.com", "", "");
        ArrayList<Tx> txs = new ArrayList<Tx>();
        txs.add(originalMessage);
        Collection recips = condition.getIncompleteRecipients(txs);
        Assertions.assertEquals((int)0, (int)recips.size());
    }
}

