/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.condition.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.condition.impl.GeneralCompletionCondition;
import org.nhindirect.monitor.util.TestUtils;

public class GeneralCompletionCondition_isCompleteTest {
    @Test
    public void testIsComplete_nullTxs_assertFalse() {
        GeneralCompletionCondition condition = new GeneralCompletionCondition();
        Assertions.assertFalse((boolean)condition.isComplete(null));
    }

    @Test
    public void testIsComplete_nullEmptyTx_assertFalse() {
        GeneralCompletionCondition condition = new GeneralCompletionCondition();
        Assertions.assertFalse((boolean)condition.isComplete(new ArrayList()));
    }

    @Test
    public void testIsComplete_noMessageToTrack_assertFalse() {
        GeneralCompletionCondition condition = new GeneralCompletionCondition();
        Tx tx = new Tx(TxMessageType.DSN, new HashMap());
        List<Tx> txs = Arrays.asList(tx);
        Assertions.assertFalse((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_noFinalRecips_assertFalse() {
        GeneralCompletionCondition condition = new GeneralCompletionCondition();
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        String msgId = UUID.randomUUID().toString();
        details.put(TxDetailType.MSG_ID.getType(), new TxDetail(TxDetailType.MSG_ID, msgId));
        Tx tx = new Tx(TxMessageType.IMF, details);
        List<Tx> txs = Arrays.asList(tx);
        Assertions.assertFalse((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_finalMDNRecipNotAnOriginalRecips_assertFalse() {
        GeneralCompletionCondition condition = new GeneralCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "ah4626@direct.securehealthemail.com", "gm2552@cerner.com", "ah4626@direct.securehealthemail.com");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertFalse((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_finalDNSRecipNotAnOriginalRecips_assertFalse() {
        GeneralCompletionCondition condition = new GeneralCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.DSN, UUID.randomUUID().toString(), originalMessageId, "ah4626@direct.securehealthemail.com", "gm2552@cerner.com", "ah4626@direct.securehealthemail.com");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertFalse((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_MDNMessageReceived_assertTrue() {
        GeneralCompletionCondition condition = new GeneralCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertTrue((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_nonQuotedFriendlyFinalRecipName_MDNMessageReceived_assertTrue() {
        GeneralCompletionCondition condition = new GeneralCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "GregMeyer <gm2552@direct.securehealthemail.com>");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertTrue((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_nonFriendlyFinalRecipName_MDNMessageReceived_assertTrue() {
        GeneralCompletionCondition condition = new GeneralCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "\"Greg Meyer\" <gm2552@direct.securehealthemail.com>");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertTrue((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_MDNMessageReceived_plusNotationOnMDNRecip_rfc822NotactionOnFinalRecip_assertTrue() {
        GeneralCompletionCondition condition = new GeneralCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.MDN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552+readreciept@cerner.com", "rfc822; gm2552@direct.securehealthemail.com");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertTrue((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_DSNMessageReceived_assertTrue() {
        GeneralCompletionCondition condition = new GeneralCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.DSN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertTrue((boolean)condition.isComplete(txs));
    }

    @Test
    public void testIsComplete_DSNMessageReceived_plusNotationOnDSNRecip_rfc822NotactionOnFinalRecip_assertTrue() {
        GeneralCompletionCondition condition = new GeneralCompletionCondition();
        String originalMessageId = UUID.randomUUID().toString();
        Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
        Tx mdnMessage = TestUtils.makeMessage(TxMessageType.DSN, UUID.randomUUID().toString(), originalMessageId, "gm2552@direct.securehealthemail.com", "gm2552+readreciept@cerner.com", "rfc822; gm2552@direct.securehealthemail.com");
        List<Tx> txs = Arrays.asList(originalMessage, mdnMessage);
        Assertions.assertTrue((boolean)condition.isComplete(txs));
    }
}

