/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.condition.impl;

import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.monitor.condition.impl.DecayingTimeoutCondition;

public class DecayingTimeoutCondition_getTimeoutTest {
    @Test
    public void testGetTimeout() {
        final long exchangeStartTime = System.currentTimeMillis();
        DecayingTimeoutCondition cond = new DecayingTimeoutCondition(10000L){

            protected long getCurrentTime() {
                return exchangeStartTime + 1000L;
            }
        };
        Assertions.assertEquals((long)9000L, (long)cond.getTimeout(new ArrayList(), exchangeStartTime));
    }

    @Test
    public void testGetTimeout_zeroTimeRemaining_assert1ms() {
        final long exchangeStartTime = System.currentTimeMillis();
        DecayingTimeoutCondition cond = new DecayingTimeoutCondition(10000L){

            protected long getCurrentTime() {
                return exchangeStartTime + 10000L;
            }
        };
        Assertions.assertEquals((long)1L, (long)cond.getTimeout(new ArrayList(), exchangeStartTime));
    }

    @Test
    public void testGetTimeout_negativeTimeRemaining_assert1ms() {
        final long exchangeStartTime = System.currentTimeMillis();
        DecayingTimeoutCondition cond = new DecayingTimeoutCondition(10000L){

            protected long getCurrentTime() {
                return exchangeStartTime + 10001L;
            }
        };
        Assertions.assertEquals((long)1L, (long)cond.getTimeout(new ArrayList(), exchangeStartTime));
    }
}

