/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.condition.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.condition.impl.AbstractCompletionCondition;

public class AbstractCompletionCondition_getMessageToTrackTest {
    @Test
    public void testGetMessageToTrack_nullTx_assertNull() {
        ConditionAdapter condition = new ConditionAdapter();
        Assertions.assertNull((Object)condition.getMessageToTrackInternal(null));
    }

    @Test
    public void testGetMessageToTrack_emptyTx_assertNull() {
        ConditionAdapter condition = new ConditionAdapter();
        Assertions.assertNull((Object)condition.getMessageToTrackInternal(new ArrayList()));
    }

    @Test
    public void testGetMessageToTrack_noIMF_assertNull() {
        ConditionAdapter condition = new ConditionAdapter();
        Tx tx = new Tx(TxMessageType.DSN, new HashMap());
        List<Tx> txs = Arrays.asList(tx);
        Assertions.assertNull((Object)condition.getMessageToTrackInternal(txs));
    }

    @Test
    public void testGetMessageToTrack_assertMessageFound() {
        ConditionAdapter condition = new ConditionAdapter();
        Tx tx = new Tx(TxMessageType.IMF, new HashMap());
        List<Tx> txs = Arrays.asList(tx);
        Tx foundTx = condition.getMessageToTrackInternal(txs);
        Assertions.assertEquals((Object)tx, (Object)foundTx);
    }

    static class ConditionAdapter
    extends AbstractCompletionCondition {
        ConditionAdapter() {
        }

        public boolean isComplete(Collection<Tx> txs) {
            return false;
        }

        public Collection<String> getIncompleteRecipients(Collection<Tx> txs) {
            return Collections.emptyList();
        }
    }
}

