/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.aggregator.repository;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.SpringBaseTest;
import org.nhindirect.monitor.aggregator.repository.ConcurrentJPAAggregationRepository;
import org.nhindirect.monitor.repository.AggregationCompletedRepository;
import org.nhindirect.monitor.repository.AggregationRepository;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ActiveProfiles;

@ActiveProfiles(value={"producerMock"})
public class ConcurrentJPAAggregationRepository_scanTest
extends SpringBaseTest {
    @Autowired
    private AggregationRepository aggRepo;
    @Autowired
    private AggregationCompletedRepository aggCompRepo;
    @Autowired
    private CamelContext context;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.aggRepo.deleteAll();
        this.aggCompRepo.deleteAll();
        List keys = this.aggRepo.findAllKeys();
        Assertions.assertEquals((int)0, (int)keys.size());
        keys = this.aggCompRepo.findAllKeys();
        Assertions.assertEquals((int)0, (int)keys.size());
    }

    @Test
    public void testScan_emptyRepository_assertEmptySet() {
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, this.aggCompRepo, 120);
        Set ids = repo.scan(this.context);
        Assertions.assertEquals((int)0, (int)ids.size());
    }

    @Test
    public void testScan_singleEntryInRepository_assertSingleKey() {
        Tx tx1 = TestUtils.makeMessage(TxMessageType.IMF, "12345", "", "me@test.com", "you@test.com", "", "", "");
        Tx tx2 = TestUtils.makeMessage(TxMessageType.IMF, "67890", "", "me@test2.com", "you@test2.com", "", "", "");
        List<Tx> txs = Arrays.asList(tx1, tx2);
        DefaultExchange exchange = new DefaultExchange(this.context);
        exchange.getIn().setBody(txs);
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, this.aggCompRepo, 120);
        repo.add(this.context, "12345", (Exchange)exchange);
        repo.remove(this.context, "12345", (Exchange)exchange);
        Set ids = repo.scan(this.context);
        Assertions.assertEquals((int)1, (int)ids.size());
        Assertions.assertEquals((Object)exchange.getExchangeId(), ids.iterator().next());
    }

    @Test
    public void testScan_nullKeys_assertEmptySet() throws Exception {
        AggregationCompletedRepository dao = (AggregationCompletedRepository)Mockito.mock(AggregationCompletedRepository.class);
        Mockito.when((Object)dao.findAllKeys()).thenReturn(null);
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, dao, 120);
        Set ids = repo.scan(this.context);
        Assertions.assertEquals((int)0, (int)ids.size());
    }

    @Test
    public void testScan_daoException_assertException() throws Exception {
        AggregationCompletedRepository dao = (AggregationCompletedRepository)Mockito.mock(AggregationCompletedRepository.class);
        ((AggregationCompletedRepository)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)dao)).findAllKeys();
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, dao, 120);
        boolean exceptionOccured = false;
        try {
            repo.scan(this.context);
        }
        catch (RuntimeException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

