/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.aggregator.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.SpringBaseTest;
import org.nhindirect.monitor.aggregator.repository.ConcurrentJPAAggregationRepository;
import org.nhindirect.monitor.repository.AggregationCompletedRepository;
import org.nhindirect.monitor.repository.AggregationRepository;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ActiveProfiles;

@ActiveProfiles(value={"producerMock"})
public class ConcurrentJPAAggregationRepository_removeTest
extends SpringBaseTest {
    @Autowired
    private AggregationRepository aggRepo;
    @Autowired
    private AggregationCompletedRepository aggCompRepo;
    @Autowired
    private CamelContext context;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.aggRepo.deleteAll();
        this.aggCompRepo.deleteAll();
        List keys = this.aggRepo.findAllKeys();
        Assertions.assertEquals((int)0, (int)keys.size());
        keys = this.aggCompRepo.findAllKeys();
        Assertions.assertEquals((int)0, (int)keys.size());
    }

    @Test
    public void testRemove_exchangeNotInRepo_assertException() {
        Tx tx = TestUtils.makeMessage(TxMessageType.IMF, "12345", "", "me@test.com", "you@test.com", "", "", "");
        DefaultExchange exchange = new DefaultExchange(this.context);
        exchange.getIn().setBody((Object)tx);
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, this.aggCompRepo, 120);
        boolean exceptionOccured = false;
        try {
            repo.remove(this.context, "12345", (Exchange)exchange);
        }
        catch (RuntimeException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testRemove_exchangeInRepo_assertRemovedAndCompletedAdded() {
        Tx tx = TestUtils.makeMessage(TxMessageType.IMF, "12345", "", "me@test.com", "you@test.com", "", "", "");
        DefaultExchange exchange = new DefaultExchange(this.context);
        exchange.setExchangeId(UUID.randomUUID().toString());
        exchange.getIn().setBody((Object)tx);
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, this.aggCompRepo, 120);
        repo.add(this.context, "12345", (Exchange)exchange);
        repo.remove(this.context, "12345", (Exchange)exchange);
        Exchange ex = repo.get(this.context, "12345");
        Assertions.assertNull((Object)ex);
        Exchange completedExchange = repo.recover(this.context, exchange.getExchangeId());
        Assertions.assertNotNull((Object)completedExchange);
        Tx completedTx = (Tx)completedExchange.getIn().getBody();
        Assertions.assertEquals((Object)"12345", (Object)completedTx.getDetail(TxDetailType.MSG_ID).getDetailValue());
    }

    @Test
    public void testRemove_exchangeWithCollectionBodyInRepo_assertRemovedAndCompletedAdded() {
        Tx tx1 = TestUtils.makeMessage(TxMessageType.IMF, "12345", "", "me@test.com", "you@test.com", "", "", "");
        Tx tx2 = TestUtils.makeMessage(TxMessageType.IMF, "67890", "", "me@test2.com", "you@test2.com", "", "", "");
        List<Tx> txs = Arrays.asList(tx1, tx2);
        DefaultExchange exchange = new DefaultExchange(this.context);
        exchange.getIn().setBody(txs);
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, this.aggCompRepo, 120);
        repo.add(this.context, "12345", (Exchange)exchange);
        repo.remove(this.context, "12345", (Exchange)exchange);
        Assertions.assertNull((Object)repo.get(this.context, "12345"));
        Exchange completedExchange = repo.recover(this.context, exchange.getExchangeId());
        Assertions.assertNotNull((Object)completedExchange);
        Collection retrievedTxs = (Collection)completedExchange.getIn().getBody();
        Assertions.assertEquals((int)2, (int)retrievedTxs.size());
        Assertions.assertEquals((Object)"12345", (Object)((Tx)retrievedTxs.iterator().next()).getDetail(TxDetailType.MSG_ID).getDetailValue());
    }
}

