/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.aggregator.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.SpringBaseTest;
import org.nhindirect.monitor.aggregator.repository.ConcurrentJPAAggregationRepository;
import org.nhindirect.monitor.repository.AggregationCompletedRepository;
import org.nhindirect.monitor.repository.AggregationRepository;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.test.context.ActiveProfiles;

@ActiveProfiles(value={"producerMock"})
public class ConcurrentJPAAggregationRepository_getTest
extends SpringBaseTest {
    @Autowired
    private AggregationRepository aggRepo;
    @Autowired
    private AggregationCompletedRepository aggCompRepo;
    @Autowired
    private CamelContext context;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.aggRepo.deleteAll();
        this.aggCompRepo.deleteAll();
        List keys = this.aggRepo.findAllKeys();
        Assertions.assertEquals((int)0, (int)keys.size());
        keys = this.aggCompRepo.findAllKeys();
        Assertions.assertEquals((int)0, (int)keys.size());
    }

    @Test
    public void testGet_emptyRepository_assertNull() throws Exception {
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, this.aggCompRepo, 120);
        Assertions.assertNull((Object)repo.get(this.context, "12345"));
    }

    @Test
    public void testGet_exchangeInRepository_txBody_assertExchangeFound() throws Exception {
        Tx tx = TestUtils.makeMessage(TxMessageType.IMF, "12345", "", "me@test.com", "you@test.com", "", "", "");
        DefaultExchange exchange = new DefaultExchange(this.context);
        exchange.getIn().setBody((Object)tx);
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, this.aggCompRepo, 120);
        repo.add(this.context, "12345", (Exchange)exchange);
        Exchange ex = repo.get(this.context, "12345");
        Assertions.assertNotNull((Object)ex);
        Tx retrievedTx = (Tx)ex.getIn().getBody();
        Assertions.assertEquals((Object)"12345", (Object)retrievedTx.getDetail(TxDetailType.MSG_ID).getDetailValue());
        Integer version = (Integer)ex.getProperty("AGGREGATION_ENTITY_VERSON");
        Assertions.assertEquals((int)0, (int)version);
    }

    @Test
    public void testGet_exchangeInRepository_txCollectionBody_assertExchangeFound() throws Exception {
        Tx tx1 = TestUtils.makeMessage(TxMessageType.IMF, "12345", "", "me@test.com", "you@test.com", "", "", "");
        Tx tx2 = TestUtils.makeMessage(TxMessageType.IMF, "67890", "", "me@test2.com", "you@test2.com", "", "", "");
        List<Tx> txs = Arrays.asList(tx1, tx2);
        DefaultExchange exchange = new DefaultExchange(this.context);
        exchange.getIn().setBody(txs);
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, this.aggCompRepo, 120);
        repo.add(this.context, "12345", (Exchange)exchange);
        Exchange ex = repo.get(this.context, "12345");
        Assertions.assertNotNull((Object)ex);
        Collection retrievedTxs = (Collection)ex.getIn().getBody();
        Assertions.assertEquals((int)2, (int)retrievedTxs.size());
        Assertions.assertEquals((Object)"12345", (Object)((Tx)retrievedTxs.iterator().next()).getDetail(TxDetailType.MSG_ID).getDetailValue());
    }

    @Test
    public void testGet_daoException_assertException() throws Exception {
        AggregationRepository dao = (AggregationRepository)Mockito.mock(AggregationRepository.class);
        ((AggregationRepository)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)dao)).findOne((Example)ArgumentMatchers.any());
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(dao, this.aggCompRepo, 120);
        boolean exceptionOccured = false;
        try {
            repo.get(this.context, "12345");
        }
        catch (RuntimeException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

