/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.aggregator.repository;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.SpringBaseTest;
import org.nhindirect.monitor.aggregator.repository.ConcurrentJPAAggregationRepository;
import org.nhindirect.monitor.repository.AggregationCompletedRepository;
import org.nhindirect.monitor.repository.AggregationRepository;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ActiveProfiles;

@ActiveProfiles(value={"producerMock"})
public class ConcurrentJPAAggregationRepository_getKeysTest
extends SpringBaseTest {
    @Autowired
    private AggregationRepository aggRepo;
    @Autowired
    private AggregationCompletedRepository aggCompRepo;
    @Autowired
    private CamelContext context;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.aggRepo.deleteAll();
        this.aggCompRepo.deleteAll();
        List keys = this.aggRepo.findAllKeys();
        Assertions.assertEquals((int)0, (int)keys.size());
        keys = this.aggCompRepo.findAllKeys();
        Assertions.assertEquals((int)0, (int)keys.size());
    }

    @Test
    public void testGetKeys_emptyRepository_assertEmptyList() {
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, this.aggCompRepo, 120);
        Set keys = repo.getKeys();
        Assertions.assertEquals((int)0, (int)keys.size());
    }

    @Test
    public void testGetKeys_singleEntry_assertSingleKey() {
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, this.aggCompRepo, 120);
        Tx tx = TestUtils.makeMessage(TxMessageType.IMF, "12345", "", "me@test.com", "you@test.com", "", "", "");
        DefaultExchange exchange = new DefaultExchange(this.context);
        exchange.getIn().setBody((Object)tx);
        repo.add(this.context, "12345", (Exchange)exchange);
        Set keys = repo.getKeys();
        Assertions.assertEquals((int)1, (int)keys.size());
        Assertions.assertEquals((Object)"12345", keys.iterator().next());
    }

    @Test
    public void testGetKeys_multipleEntries_assertMultipleKeys() {
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, this.aggCompRepo, 120);
        Tx tx1 = TestUtils.makeMessage(TxMessageType.IMF, "12345", "", "me@test.com", "you@test.com", "", "", "");
        DefaultExchange exchange1 = new DefaultExchange(this.context);
        exchange1.getIn().setBody((Object)tx1);
        repo.add(this.context, "12345", (Exchange)exchange1);
        Tx tx2 = TestUtils.makeMessage(TxMessageType.IMF, "123456", "", "me@test.com", "you@test.com", "", "", "");
        DefaultExchange exchange2 = new DefaultExchange(this.context);
        exchange2.getIn().setBody((Object)tx2);
        repo.add(this.context, "123456", (Exchange)exchange2);
        Set keys = repo.getKeys();
        Assertions.assertEquals((int)2, (int)keys.size());
        Iterator iter = keys.iterator();
        Assertions.assertEquals((Object)"12345", iter.next());
        Assertions.assertEquals((Object)"123456", iter.next());
    }

    @Test
    public void testGetKeys_daoException_assertException() throws Exception {
        AggregationRepository dao = (AggregationRepository)Mockito.mock(AggregationRepository.class);
        ((AggregationRepository)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)dao)).findAllKeys();
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(dao, this.aggCompRepo, 120);
        boolean exceptionOccured = false;
        try {
            repo.getKeys();
        }
        catch (RuntimeException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

