/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.aggregator.repository;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nhindirect.monitor.aggregator.repository.ConcurrentJPAAggregationRepository;
import org.nhindirect.monitor.repository.AggregationCompletedRepository;
import org.nhindirect.monitor.repository.AggregationRepository;

public class ConcurrentJPAAggregationRepository_doStartTest {
    @Test
    public void testDoStart_emptyAggregation_assertNoException() throws Exception {
        AggregationRepository aggRepo = (AggregationRepository)Mockito.mock(AggregationRepository.class);
        AggregationCompletedRepository aggCompRepo = (AggregationCompletedRepository)Mockito.mock(AggregationCompletedRepository.class);
        Mockito.when((Object)aggRepo.findAllKeys()).thenReturn(new ArrayList());
        Mockito.when((Object)aggCompRepo.findAllKeys()).thenReturn(new ArrayList());
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(aggRepo, aggCompRepo, 120);
        repo.doStart();
        repo.doStop();
    }

    @Test
    public void testDoStart_nonEmptyAggregation_assertNoException() throws Exception {
        AggregationRepository aggRepo = (AggregationRepository)Mockito.mock(AggregationRepository.class);
        AggregationCompletedRepository aggCompRepo = (AggregationCompletedRepository)Mockito.mock(AggregationCompletedRepository.class);
        Mockito.when((Object)aggRepo.findAllKeys()).thenReturn(Arrays.asList("12345"));
        Mockito.when((Object)aggCompRepo.findAllKeys()).thenReturn(Arrays.asList("12345"));
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(aggRepo, aggCompRepo, 120);
        repo.doStart();
        repo.doStop();
    }

    @Test
    public void testDoStart_emptyDAO_assertException() throws Exception {
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository();
        boolean exceptionOccured = false;
        try {
            repo.doStart();
        }
        catch (RuntimeException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

