/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.aggregator.repository;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.SpringBaseTest;
import org.nhindirect.monitor.aggregator.repository.ConcurrentJPAAggregationRepository;
import org.nhindirect.monitor.repository.AggregationCompletedRepository;
import org.nhindirect.monitor.repository.AggregationRepository;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ActiveProfiles;

@ActiveProfiles(value={"producerMock"})
public class ConcurrentJPAAggregationRepository_confirmTest
extends SpringBaseTest {
    @Autowired
    private AggregationRepository aggRepo;
    @Autowired
    private AggregationCompletedRepository aggCompRepo;
    @Autowired
    private CamelContext context;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.aggRepo.deleteAll();
        this.aggCompRepo.deleteAll();
        List keys = this.aggRepo.findAllKeys();
        Assertions.assertEquals((int)0, (int)keys.size());
        keys = this.aggCompRepo.findAllKeys();
        Assertions.assertEquals((int)0, (int)keys.size());
    }

    @Test
    public void testConfirm_exchangeNotInRepository_assertNoException() {
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, this.aggCompRepo, 120);
        repo.confirm(this.context, "12345");
    }

    @Test
    public void testConfirm_completedExchangeInRepository_assertExchangeRemoved() {
        Tx tx = TestUtils.makeMessage(TxMessageType.IMF, "12345", "", "me@test.com", "you@test.com", "", "", "");
        DefaultExchange exchange = new DefaultExchange(this.context);
        exchange.getIn().setBody((Object)tx);
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, this.aggCompRepo, 120);
        repo.add(this.context, "12345", (Exchange)exchange);
        repo.remove(this.context, "12345", (Exchange)exchange);
        Assertions.assertNull((Object)repo.get(this.context, "12345"));
        Exchange completedExchange = repo.recover(this.context, exchange.getExchangeId());
        Assertions.assertNotNull((Object)completedExchange);
        repo.confirm(this.context, exchange.getExchangeId());
        Assertions.assertNull((Object)repo.recover(this.context, exchange.getExchangeId()));
    }
}

