/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.aggregator.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.monitor.SpringBaseTest;
import org.nhindirect.monitor.aggregator.repository.ConcurrentJPAAggregationRepository;
import org.nhindirect.monitor.repository.AggregationCompletedRepository;
import org.nhindirect.monitor.repository.AggregationRepository;
import org.nhindirect.monitor.util.TestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ActiveProfiles;

@ActiveProfiles(value={"producerMock"})
public class ConcurrentJPAAggregationRepository_addTest
extends SpringBaseTest {
    @Autowired
    private AggregationRepository aggRepo;
    @Autowired
    private AggregationCompletedRepository aggCompRepo;
    @Autowired
    private CamelContext context;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.aggRepo.deleteAll();
        this.aggCompRepo.deleteAll();
        List keys = this.aggRepo.findAllKeys();
        Assertions.assertEquals((int)0, (int)keys.size());
        keys = this.aggCompRepo.findAllKeys();
        Assertions.assertEquals((int)0, (int)keys.size());
    }

    @Test
    public void testAdd_emptyRepository_addExchangeWithTxBody_assertExchangeAdded() {
        Tx tx = TestUtils.makeMessage(TxMessageType.IMF, "12345", "", "me@test.com", "you@test.com", "", "", "");
        DefaultExchange exchange = new DefaultExchange(this.context);
        exchange.getIn().setBody((Object)tx);
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, this.aggCompRepo, 120);
        repo.add(this.context, "12345", (Exchange)exchange);
        Exchange ex = repo.get(this.context, "12345");
        Assertions.assertNotNull((Object)ex);
        Tx retrievedTx = (Tx)ex.getIn().getBody();
        Assertions.assertEquals((Object)"12345", (Object)retrievedTx.getDetail(TxDetailType.MSG_ID).getDetailValue());
        Integer version = (Integer)ex.getProperty("AGGREGATION_ENTITY_VERSON");
        Assertions.assertEquals((int)0, (int)version);
    }

    @Test
    public void testAdd_existingExchange_updateBody_assertExchangeAdded() {
        Tx tx = TestUtils.makeMessage(TxMessageType.IMF, "12345", "", "me@test.com", "you@test.com", "", "", "");
        DefaultExchange exchange = new DefaultExchange(this.context);
        exchange.getIn().setBody((Object)tx);
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, this.aggCompRepo, 120);
        repo.add(this.context, "12345", (Exchange)exchange);
        Exchange retrievedEx = repo.get(this.context, "12345");
        Tx tx1 = TestUtils.makeMessage(TxMessageType.IMF, "12345", "", "me@test.com", "you@test.com", "", "", "");
        Tx tx2 = TestUtils.makeMessage(TxMessageType.IMF, "67890", "", "me@test2.com", "you@test2.com", "", "", "");
        List<Tx> txs = Arrays.asList(tx1, tx2);
        retrievedEx.getIn().setBody(txs);
        repo.add(this.context, "12345", retrievedEx);
        retrievedEx = repo.get(this.context, "12345");
        Collection retrievedTxs = (Collection)retrievedEx.getIn().getBody();
        Assertions.assertEquals((int)2, (int)retrievedTxs.size());
        Assertions.assertEquals((Object)"12345", (Object)((Tx)retrievedTxs.iterator().next()).getDetail(TxDetailType.MSG_ID).getDetailValue());
        Integer version = (Integer)retrievedEx.getProperty("AGGREGATION_ENTITY_VERSON");
        Assertions.assertEquals((int)1, (int)version);
    }

    @Test
    public void testAdd_existingExchange_invalidVersion_assertExchangeAdded() {
        Tx tx = TestUtils.makeMessage(TxMessageType.IMF, "12345", "", "me@test.com", "you@test.com", "", "", "");
        DefaultExchange exchange = new DefaultExchange(this.context);
        exchange.getIn().setBody((Object)tx);
        ConcurrentJPAAggregationRepository repo = new ConcurrentJPAAggregationRepository(this.aggRepo, this.aggCompRepo, 120);
        repo.add(this.context, "12345", (Exchange)exchange);
        Exchange retrievedEx = repo.get(this.context, "12345");
        Tx tx1 = TestUtils.makeMessage(TxMessageType.IMF, "12345", "", "me@test.com", "you@test.com", "", "", "");
        Tx tx2 = TestUtils.makeMessage(TxMessageType.IMF, "67890", "", "me@test2.com", "you@test2.com", "", "", "");
        List<Tx> txs = Arrays.asList(tx1, tx2);
        retrievedEx.getIn().setBody(txs);
        retrievedEx.setProperty("AGGREGATION_ENTITY_VERSON", (Object)35);
        boolean exceptionOccured = false;
        try {
            repo.add(this.context, "12345", retrievedEx);
        }
        catch (RuntimeException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        Exchange ex = repo.get(this.context, "12345");
        Assertions.assertNotNull((Object)ex);
        Tx retrievedTx = (Tx)ex.getIn().getBody();
        Assertions.assertEquals((Object)"12345", (Object)retrievedTx.getDetail(TxDetailType.MSG_ID).getDetailValue());
        Integer version = (Integer)ex.getProperty("AGGREGATION_ENTITY_VERSON");
        Assertions.assertEquals((int)0, (int)version);
    }
}

