/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.monitor.aggregator.BasicTxAggregator;
import org.nhindirect.monitor.condition.TxCompletionCondition;

public class BasicTxAggregator_isCompleteTest {
    @Test
    public void testIsComplete_nullCompletionCondtion() {
        BasicTxAggregator aggr = new BasicTxAggregator(null, null);
        boolean exceptionOccurred = false;
        try {
            Exchange exchange = (Exchange)Mockito.mock(Exchange.class);
            aggr.isAggregationComplete(exchange);
        }
        catch (IllegalStateException e) {
            exceptionOccurred = true;
        }
        Assertions.assertTrue((boolean)exceptionOccurred);
    }

    @Test
    public void testIsComplete_emptyTxs_assertFalse() {
        TxCompletionCondition condition = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        BasicTxAggregator aggr = new BasicTxAggregator(condition, null);
        Message msg = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)msg.getBody(Collection.class)).thenReturn(null);
        Exchange exchange = (Exchange)Mockito.mock(Exchange.class);
        Mockito.when((Object)exchange.getIn()).thenReturn((Object)msg);
        Assertions.assertFalse((boolean)aggr.isAggregationComplete(exchange));
    }

    @Test
    public void testIsComplete_txsExists_assertFalse() {
        TxCompletionCondition condition = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        Mockito.when((Object)condition.isComplete((Collection)ArgumentMatchers.any())).thenReturn((Object)false);
        BasicTxAggregator aggr = new BasicTxAggregator(condition, null);
        Tx tx = (Tx)Mockito.mock(Tx.class);
        ArrayList<Tx> oldTxs = new ArrayList<Tx>();
        oldTxs.add(tx);
        Message msg = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)msg.getBody(Collection.class)).thenReturn(oldTxs);
        Exchange exchange = (Exchange)Mockito.mock(Exchange.class);
        Mockito.when((Object)exchange.getIn()).thenReturn((Object)msg);
        Assertions.assertFalse((boolean)aggr.isAggregationComplete(exchange));
    }

    @Test
    public void testIsComplete_txsExists_assertTrue() {
        TxCompletionCondition condition = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        Mockito.when((Object)condition.isComplete((Collection)ArgumentMatchers.any())).thenReturn((Object)true);
        BasicTxAggregator aggr = new BasicTxAggregator(condition, null);
        Tx tx = (Tx)Mockito.mock(Tx.class);
        ArrayList<Tx> oldTxs = new ArrayList<Tx>();
        oldTxs.add(tx);
        Message msg = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)msg.getBody(Collection.class)).thenReturn(oldTxs);
        Exchange exchange = (Exchange)Mockito.mock(Exchange.class);
        Mockito.when((Object)exchange.getIn()).thenReturn((Object)msg);
        Assertions.assertTrue((boolean)aggr.isAggregationComplete(exchange));
    }
}

