/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.monitor.aggregator.BasicTxAggregator;
import org.nhindirect.monitor.condition.TxTimeoutCondition;

public class BasicTxAggregator_getAggregationTimeTest {
    @Test
    public void testGetAggregationTime_nullTimeoutCondtion() {
        BasicTxAggregator aggr = new BasicTxAggregator(null, null);
        boolean exceptionOccurred = false;
        try {
            Exchange exchange = (Exchange)Mockito.mock(Exchange.class);
            aggr.getAggregationTime(exchange);
        }
        catch (IllegalStateException e) {
            exceptionOccurred = true;
        }
        Assertions.assertTrue((boolean)exceptionOccurred);
    }

    @Test
    public void testGetAggregationTime_emptyTxs_assertNull() {
        TxTimeoutCondition condition = (TxTimeoutCondition)Mockito.mock(TxTimeoutCondition.class);
        BasicTxAggregator aggr = new BasicTxAggregator(null, condition);
        Message msg = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)msg.getBody(Collection.class)).thenReturn(null);
        Exchange exchange = (Exchange)Mockito.mock(Exchange.class);
        Mockito.when((Object)exchange.getIn()).thenReturn((Object)msg);
        Assertions.assertNull((Object)aggr.getAggregationTime(exchange));
        ((Exchange)Mockito.verify((Object)exchange, (VerificationMode)Mockito.never())).getProperty("CamelCreatedTimestamp", Date.class);
    }

    @Test
    public void testIsComplete_txsExists_emptyInitialTimeProperty_assertNull() {
        TxTimeoutCondition condition = (TxTimeoutCondition)Mockito.mock(TxTimeoutCondition.class);
        BasicTxAggregator aggr = new BasicTxAggregator(null, condition);
        Tx tx = (Tx)Mockito.mock(Tx.class);
        ArrayList<Tx> oldTxs = new ArrayList<Tx>();
        oldTxs.add(tx);
        Message msg = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)msg.getBody(Collection.class)).thenReturn(oldTxs);
        Exchange exchange = (Exchange)Mockito.mock(Exchange.class);
        Mockito.when((Object)exchange.getIn()).thenReturn((Object)msg);
        Mockito.when((Object)exchange.getProperty("CamelCreatedTimestamp", Date.class)).thenReturn(null);
        Assertions.assertNull((Object)aggr.getAggregationTime(exchange));
        ((Exchange)Mockito.verify((Object)exchange, (VerificationMode)Mockito.times((int)1))).getProperty("CamelCreatedTimestamp", Date.class);
    }

    @Test
    public void testIsComplete_txsExists_propertyExists_assertTimeoutValue() {
        Date theDate = new Date();
        TxTimeoutCondition condition = (TxTimeoutCondition)Mockito.mock(TxTimeoutCondition.class);
        Mockito.when((Object)condition.getTimeout((Collection)ArgumentMatchers.any(), ArgumentMatchers.eq((long)theDate.getTime()))).thenReturn((Object)1000L);
        BasicTxAggregator aggr = new BasicTxAggregator(null, condition);
        Tx tx = (Tx)Mockito.mock(Tx.class);
        ArrayList<Tx> oldTxs = new ArrayList<Tx>();
        oldTxs.add(tx);
        Message msg = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)msg.getBody(Collection.class)).thenReturn(oldTxs);
        Exchange exchange = (Exchange)Mockito.mock(Exchange.class);
        Mockito.when((Object)exchange.getIn()).thenReturn((Object)msg);
        Mockito.when((Object)exchange.getProperty("CamelCreatedTimestamp", Date.class)).thenReturn((Object)theDate);
        Assertions.assertEquals((Long)1000L, (Long)aggr.getAggregationTime(exchange));
        ((Exchange)Mockito.verify((Object)exchange, (VerificationMode)Mockito.times((int)1))).getProperty("CamelCreatedTimestamp", Date.class);
    }
}

