/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.monitor.aggregator.BasicTxAggregator;
import org.nhindirect.monitor.condition.TxCompletionCondition;
import org.nhindirect.monitor.condition.TxTimeoutCondition;

public class BasicTxAggregator_aggregateTest {
    @Test
    public void testAggregate_emptyExchanged_addTx() {
        TxTimeoutCondition timoutCondition = (TxTimeoutCondition)Mockito.mock(TxTimeoutCondition.class);
        TxCompletionCondition condition = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        BasicTxAggregator aggr = new BasicTxAggregator(condition, timoutCondition);
        CamelContext context = (CamelContext)Mockito.mock(CamelContext.class);
        DefaultExchange newExchange = new DefaultExchange(context);
        Tx tx = (Tx)Mockito.mock(Tx.class);
        newExchange.getIn().setBody((Object)tx);
        Exchange ex = aggr.aggregate(null, (Exchange)newExchange);
        Collection txs = (Collection)ex.getIn().getBody(Collection.class);
        Assertions.assertEquals((int)1, (int)txs.size());
        Assertions.assertEquals((Object)tx, txs.iterator().next());
    }

    @Test
    public void testAggregate_singleEntryExchanged_addSingleTx() {
        TxTimeoutCondition timoutCondition = (TxTimeoutCondition)Mockito.mock(TxTimeoutCondition.class);
        TxCompletionCondition condition = (TxCompletionCondition)Mockito.mock(TxCompletionCondition.class);
        BasicTxAggregator aggr = new BasicTxAggregator(condition, timoutCondition);
        CamelContext context = (CamelContext)Mockito.mock(CamelContext.class);
        DefaultExchange oldExchange = new DefaultExchange(context);
        Tx tx = (Tx)Mockito.mock(Tx.class);
        ArrayList<Tx> oldTxs = new ArrayList<Tx>();
        oldTxs.add(tx);
        oldExchange.getIn().setBody(oldTxs);
        DefaultExchange newExchange = new DefaultExchange(context);
        tx = (Tx)Mockito.mock(Tx.class);
        newExchange.getIn().setBody((Object)tx);
        Exchange ex = aggr.aggregate((Exchange)oldExchange, (Exchange)newExchange);
        Collection txs = (Collection)ex.getIn().getBody(Collection.class);
        Assertions.assertEquals((int)2, (int)txs.size());
    }
}

