/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.urlcanon;

import org.netpreserve.urlcanon.ParsedUrl;

class UrlParser {
    UrlParser() {
    }

    static ParsedUrl parseUrl(String s) {
        int pos;
        ParsedUrl url = new ParsedUrl();
        int len = s.length();
        for (pos = 0; pos < len && s.charAt(pos) <= ' '; ++pos) {
        }
        url.setLeadingJunk(s.substring(0, pos));
        while (pos < len && s.charAt(len - 1) <= ' ') {
            --len;
        }
        url.setTrailingJunk(s.substring(len));
        if (pos < len && (s.charAt(pos) >= 'a' && s.charAt(pos) <= 'z' || s.charAt(pos) >= 'A' && s.charAt(pos) <= 'Z')) {
            int schemeStart = pos;
            while (pos < len && s.charAt(pos) != ':') {
                ++pos;
            }
            if (pos < len && s.charAt(pos) == ':') {
                url.setScheme(s.substring(schemeStart, pos));
                url.setColonAfterScheme(":");
                ++pos;
            } else {
                pos = schemeStart;
                url.setScheme("");
                url.setColonAfterScheme("");
            }
        } else {
            url.setScheme("");
            url.setColonAfterScheme("");
        }
        int pathishStart = pos;
        while (pos < len && s.charAt(pos) != '#' && s.charAt(pos) != '?') {
            ++pos;
        }
        UrlParser.parsePathish(url, s, pathishStart, pos);
        if (pos < len && s.charAt(pos) == '?') {
            url.setQuestionMark("?");
            int queryStart = ++pos;
            while (pos < len && s.charAt(pos) != '#') {
                ++pos;
            }
            url.setQuery(s.substring(queryStart, pos));
        } else {
            url.setQuestionMark("");
            url.setQuery("");
        }
        if (pos < len && s.charAt(pos) == '#') {
            url.setHashSign("#");
            url.setFragment(s.substring(++pos, len));
        } else {
            url.setHashSign("");
            url.setFragment("");
        }
        return url;
    }

    static void parsePathish(ParsedUrl url, String s, int pos, int end) {
        String cleanScheme = UrlParser.removeTabsAndNewlinesAndLowercase(url.getScheme());
        boolean isSpecial = ParsedUrl.SPECIAL_SCHEMES.containsKey(cleanScheme);
        boolean isFile = cleanScheme.equals("file");
        int slashCount = 0;
        int slashesStart = pos;
        block5: while (pos < end) {
            switch (s.charAt(pos)) {
                case '\\': {
                    if (!isSpecial) break block5;
                }
                case '/': {
                    if (isFile || !isSpecial) {
                        if (slashCount == 2) break block5;
                        ++slashCount;
                    }
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    ++pos;
                    continue block5;
                }
            }
        }
        url.setSlashes(s.substring(slashesStart, pos));
        if (isFile) {
            if (slashCount != 2) {
                url.setPath(s.substring(slashesStart, end));
                url.setSlashes("");
                url.setUsername("");
                url.setColonBeforePassword("");
                url.setPassword("");
                url.setAtSign("");
                url.setHost("");
                url.setColonBeforePort("");
                url.setPort("");
                return;
            }
            int startOfHost = pos;
            while (pos < end && s.charAt(pos) != '/' && s.charAt(pos) != '\\') {
                ++pos;
            }
            url.setHost(s.substring(startOfHost, pos));
            url.setUsername("");
            url.setColonBeforePassword("");
            url.setPassword("");
            url.setAtSign("");
            url.setColonBeforePort("");
            url.setPort("");
        } else if (isSpecial) {
            int startOfAuthority = pos;
            while (pos < end && s.charAt(pos) != '/' && s.charAt(pos) != '\\') {
                ++pos;
            }
            UrlParser.parseAuthority(url, s, startOfAuthority, pos);
        } else {
            if (!UrlParser.removeTabsAndNewlinesAndLowercase(url.getSlashes()).equals("//")) {
                url.setPath(s.substring(slashesStart, end));
                url.setSlashes("");
                url.setUsername("");
                url.setColonBeforePassword("");
                url.setPassword("");
                url.setAtSign("");
                url.setHost("");
                url.setColonBeforePort("");
                url.setPort("");
                return;
            }
            int startOfAuthority = pos;
            while (pos < end && s.charAt(pos) != '/') {
                ++pos;
            }
            UrlParser.parseAuthority(url, s, startOfAuthority, pos);
        }
        url.setPath(s.substring(pos, end));
    }

    private static void parseAuthority(ParsedUrl url, String s, int pos, int end) {
        int userinfoStart = pos;
        int userinfoEnd = -1;
        for (int i = pos; i < end; ++i) {
            if (s.charAt(i) != '@') continue;
            userinfoEnd = i;
        }
        if (userinfoEnd != -1) {
            UrlParser.parseUserinfo(url, s, userinfoStart, userinfoEnd);
            pos = userinfoEnd + 1;
            url.setAtSign("@");
        } else {
            url.setUsername("");
            url.setColonBeforePassword("");
            url.setPassword("");
            url.setAtSign("");
        }
        int hostStart = pos;
        if (pos < end && s.charAt(pos) == '[') {
            ++pos;
            while (pos < end && s.charAt(pos) != ']') {
                ++pos;
            }
            if (pos < end && s.charAt(pos) == ']' && ++pos < end && s.charAt(pos) != ':') {
                pos = hostStart;
            }
        }
        while (pos < end && s.charAt(pos) != ':') {
            ++pos;
        }
        url.setHost(s.substring(hostStart, pos));
        if (pos < end && s.charAt(pos) == ':') {
            url.setColonBeforePort(":");
            url.setPort(s.substring(++pos, end));
        } else {
            url.setColonBeforePort("");
            url.setPort("");
        }
    }

    private static void parseUserinfo(ParsedUrl url, String s, int i, int end) {
        int usernameStart = i;
        while (i < end && s.charAt(i) != ':') {
            ++i;
        }
        url.setUsername(s.substring(usernameStart, i));
        if (i < end && s.charAt(i) == ':') {
            url.setColonBeforePassword(":");
            url.setPassword(s.substring(++i, end));
        } else {
            url.setColonBeforePassword("");
            url.setPassword("");
        }
    }

    private static String removeTabsAndNewlinesAndLowercase(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\t' || c == '\n' || c == '\r') continue;
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

