/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.urlcanon;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.netpreserve.urlcanon.Canonicalizer;
import org.netpreserve.urlcanon.ParsedUrl;
import org.netpreserve.urlcanon.UrlParser;
import org.netpreserve.urlcanon.WhatwgCanonicalizer;

public class SemanticPreciseCanonicalizer
implements Canonicalizer {
    private static final Pattern TWO_OR_MORE_SLASHES_RE = Pattern.compile("//+");
    static final boolean[] GOOGLE_PCT_ENCODE = WhatwgCanonicalizer.buildEncodeSet("[\\x00-\\x20\\x7f-\\xff#%]");
    static final boolean[] LESS_DUMB_USERINFO_ENCODE = WhatwgCanonicalizer.buildEncodeSet("[\\x00-\\x20\\x7f-\\xff#%:@]");
    static final boolean[] LESS_DUMB_PATH_ENCODE = WhatwgCanonicalizer.buildEncodeSet("[\\x00-\\x20\\x7f-\\xff#%?]");
    static final boolean[] LESS_DUMB_QUERY_ENCODE = WhatwgCanonicalizer.buildEncodeSet("[\\x00-\\x20\\x7f-\\xff#%&=]");

    @Override
    public void canonicalize(ParsedUrl url) {
        this.canonicalize(url, StandardCharsets.UTF_8);
    }

    public void canonicalize(ParsedUrl url, Charset charset) {
        WhatwgCanonicalizer.removeLeadingTrailingJunk(url);
        SemanticPreciseCanonicalizer.defaultSchemeHttp(url);
        WhatwgCanonicalizer.removeTabsAndNewlines(url);
        WhatwgCanonicalizer.lowercaseScheme(url);
        WhatwgCanonicalizer.elideDefaultPort(url);
        WhatwgCanonicalizer.cleanUpUserinfo(url);
        WhatwgCanonicalizer.twoSlashes(url);
        SemanticPreciseCanonicalizer.pctDecodeRepeatedlyExceptQuery(url, charset);
        WhatwgCanonicalizer.normalizeIpAddress(url);
        this.fixHostDots(url);
        WhatwgCanonicalizer.punycodeSpecialHost(url, charset);
        SemanticPreciseCanonicalizer.removeUserinfo(url);
        SemanticPreciseCanonicalizer.lessDumbPctEncode(url, charset);
        SemanticPreciseCanonicalizer.lessDumbPctRecodeQuery(url, charset);
        WhatwgCanonicalizer.fixBackslashes(url);
        WhatwgCanonicalizer.leadingSlash(url);
        WhatwgCanonicalizer.normalizePathDots(url);
        this.collapseConsecutiveSlashes(url);
        WhatwgCanonicalizer.emptyPathToSlash(url);
        SemanticPreciseCanonicalizer.alphaReorderQuery(url);
    }

    static String removeLeadingTrailingAndDuplicateChars(String s, char charToRemove) {
        if (s.indexOf(charToRemove) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        char prev = charToRemove;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != charToRemove || prev != charToRemove) {
                sb.append(c);
            }
            prev = c;
        }
        if (sb.charAt(sb.length() - 1) == charToRemove) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private void fixHostDots(ParsedUrl url) {
        url.setHost(SemanticPreciseCanonicalizer.removeLeadingTrailingAndDuplicateChars(url.getHost(), '.'));
    }

    private void collapseConsecutiveSlashes(ParsedUrl url) {
        if (ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme())) {
            url.setPath(TWO_OR_MORE_SLASHES_RE.matcher(url.getPath()).replaceAll("/"));
        }
    }

    static void defaultSchemeHttp(ParsedUrl url) {
        if (url.getScheme().isEmpty()) {
            url.setScheme(new String("http"));
            url.setColonAfterScheme(new String(":"));
            if (!url.getPath().isEmpty()) {
                UrlParser.parsePathish(url, url.getPath(), 0, url.getPath().length());
            }
        }
    }

    static void pctDecodeRepeatedlyExceptQuery(ParsedUrl url, Charset charset) {
        url.setScheme(SemanticPreciseCanonicalizer.pctDecodeTokenRepeatedly(url.getScheme(), charset));
        url.setUsername(SemanticPreciseCanonicalizer.pctDecodeTokenRepeatedly(url.getUsername(), charset));
        url.setPassword(SemanticPreciseCanonicalizer.pctDecodeTokenRepeatedly(url.getPassword(), charset));
        url.setHost(SemanticPreciseCanonicalizer.pctDecodeTokenRepeatedly(url.getHost(), charset));
        url.setPort(SemanticPreciseCanonicalizer.pctDecodeTokenRepeatedly(url.getPort(), charset));
        url.setPath(SemanticPreciseCanonicalizer.pctDecodeTokenRepeatedly(url.getPath(), charset));
        url.setFragment(SemanticPreciseCanonicalizer.pctDecodeTokenRepeatedly(url.getFragment(), charset));
    }

    static String pctDecodeTokenRepeatedly(String str, Charset charset) {
        String decoded;
        while (!(decoded = WhatwgCanonicalizer.pctDecode(str, charset)).equals(str)) {
            str = decoded;
        }
        return decoded;
    }

    static void removeUserinfo(ParsedUrl url) {
        url.setUsername("");
        url.setColonBeforePassword("");
        url.setPassword("");
        url.setAtSign("");
    }

    static void lessDumbPctEncode(ParsedUrl url, Charset charset) {
        url.setScheme(WhatwgCanonicalizer.pctEncode(url.getScheme(), GOOGLE_PCT_ENCODE, charset));
        url.setScheme(WhatwgCanonicalizer.pctEncode(url.getScheme(), GOOGLE_PCT_ENCODE, charset));
        url.setUsername(WhatwgCanonicalizer.pctEncode(url.getUsername(), LESS_DUMB_USERINFO_ENCODE, charset));
        url.setPassword(WhatwgCanonicalizer.pctEncode(url.getPassword(), LESS_DUMB_USERINFO_ENCODE, charset));
        url.setHost(WhatwgCanonicalizer.pctEncode(url.getHost(), GOOGLE_PCT_ENCODE, charset));
        url.setPort(WhatwgCanonicalizer.pctEncode(url.getPort(), GOOGLE_PCT_ENCODE, charset));
        url.setPath(WhatwgCanonicalizer.pctEncode(url.getPath(), LESS_DUMB_PATH_ENCODE, charset));
        url.setFragment(WhatwgCanonicalizer.pctEncode(url.getFragment(), GOOGLE_PCT_ENCODE, charset));
    }

    private static String pctRecodeQueryPart(String s, Charset charset) {
        String decoded = SemanticPreciseCanonicalizer.pctDecodeTokenRepeatedly(s, charset);
        return WhatwgCanonicalizer.pctEncode(decoded, LESS_DUMB_QUERY_ENCODE, charset);
    }

    static void lessDumbPctRecodeQuery(ParsedUrl url, Charset charset) {
        String query = url.getQuery();
        if (query.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < query.length()) {
            int eq = query.indexOf(61, i);
            int amp = query.indexOf(38, i);
            if (amp == -1) {
                amp = query.length();
            }
            if (eq != -1 && eq < amp) {
                sb.append(SemanticPreciseCanonicalizer.pctRecodeQueryPart(query.substring(i, eq), charset));
                sb.append('=');
                i = eq + 1;
            }
            sb.append(SemanticPreciseCanonicalizer.pctRecodeQueryPart(query.substring(i, amp), charset));
            if (amp < query.length()) {
                sb.append('&');
            }
            i = amp + 1;
        }
        url.setQuery(sb.toString());
    }

    static void alphaReorderQuery(ParsedUrl url) {
        List<String> params = Arrays.asList(url.getQuery().split("&"));
        Collections.sort(params);
        url.setQuery(String.join((CharSequence)"&", params));
    }
}

