/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.urlcanon;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.netpreserve.urlcanon.IpAddresses;
import org.netpreserve.urlcanon.UrlParser;

public class ParsedUrl {
    static final Map<String, Integer> SPECIAL_SCHEMES = ParsedUrl.initSpecialSchemes();
    private String leadingJunk;
    private String trailingJunk;
    private String scheme;
    private String colonAfterScheme;
    private String questionMark;
    private String query;
    private String hashSign;
    private String fragment;
    private String slashes;
    private String path;
    private String username;
    private String colonBeforePassword;
    private String password;
    private String atSign;
    private String host;
    private String colonBeforePort;
    private String port;

    private static Map<String, Integer> initSpecialSchemes() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("ftp", 21);
        map.put("gopher", 70);
        map.put("http", 80);
        map.put("https", 443);
        map.put("ws", 80);
        map.put("wss", 443);
        map.put("file", null);
        return map;
    }

    ParsedUrl() {
    }

    public ParsedUrl(ParsedUrl parsedUrl) {
        this.leadingJunk = parsedUrl.getLeadingJunk();
        this.trailingJunk = parsedUrl.getTrailingJunk();
        this.scheme = parsedUrl.getScheme();
        this.colonAfterScheme = parsedUrl.getColonAfterScheme();
        this.questionMark = parsedUrl.getQuestionMark();
        this.query = parsedUrl.getQuery();
        this.hashSign = parsedUrl.getHashSign();
        this.fragment = parsedUrl.getFragment();
        this.slashes = parsedUrl.getSlashes();
        this.path = parsedUrl.getPath();
        this.username = parsedUrl.getUsername();
        this.colonBeforePassword = parsedUrl.getColonBeforePassword();
        this.password = parsedUrl.getPassword();
        this.atSign = parsedUrl.getAtSign();
        this.host = parsedUrl.getHost();
        this.colonBeforePort = parsedUrl.getColonBeforePort();
        this.port = parsedUrl.getPort();
    }

    private ParsedUrl(ParsedUrl base, ParsedUrl relative) {
        this.leadingJunk = relative.leadingJunk;
        this.trailingJunk = relative.trailingJunk;
        this.scheme = relative.scheme;
        this.colonAfterScheme = relative.colonAfterScheme;
        this.questionMark = relative.questionMark;
        this.query = relative.query;
        this.hashSign = relative.hashSign;
        this.fragment = relative.fragment;
        this.slashes = relative.slashes;
        this.path = relative.path;
        this.username = relative.username;
        this.colonBeforePassword = relative.colonBeforePassword;
        this.password = relative.password;
        this.atSign = relative.atSign;
        this.host = relative.host;
        this.colonBeforePort = relative.colonBeforePort;
        this.port = relative.port;
        if (!this.slashes.isEmpty()) {
            if (this.scheme.isEmpty()) {
                this.scheme = base.scheme;
            }
            return;
        }
        if (!this.scheme.isEmpty() && !this.scheme.equalsIgnoreCase(base.scheme)) {
            return;
        }
        if (this.scheme.isEmpty() || this.scheme.equalsIgnoreCase(base.scheme)) {
            this.scheme = base.scheme;
            this.colonAfterScheme = base.colonAfterScheme;
            this.username = base.username;
            this.colonBeforePassword = base.colonBeforePassword;
            this.password = base.password;
            this.atSign = base.atSign;
            this.host = base.host;
            this.colonBeforePort = base.colonBeforePort;
            this.port = base.port;
        }
        if (this.path.isEmpty() && !relative.host.isEmpty()) {
            this.path = relative.host;
        }
        if (this.path.isEmpty() || this.path.charAt(0) == '/') {
            return;
        }
        this.path = base.dirname() + this.path;
    }

    private String dirname() {
        for (int i = this.path.length() - 1; i >= 0; --i) {
            if (this.path.charAt(i) != '/') continue;
            return this.path.substring(0, i + 1);
        }
        return "";
    }

    public static ParsedUrl parseUrl(byte[] bytes) {
        return ParsedUrl.parseUrl(new String(bytes));
    }

    public static ParsedUrl parseUrl(String input) {
        return UrlParser.parseUrl(input);
    }

    public String toString() {
        return this.leadingJunk + this.scheme + this.colonAfterScheme + this.slashes + this.username + this.colonBeforePassword + this.password + this.atSign + this.host + this.colonBeforePort + this.port + this.path + this.questionMark + this.query + this.hashSign + this.fragment + this.trailingJunk;
    }

    public String ssurt() {
        return this.leadingJunk + ParsedUrl.ssurtHost(this.host) + this.slashes + this.port + this.colonBeforePort + this.scheme + this.atSign + this.username + this.colonBeforePassword + this.password + this.colonAfterScheme + this.path + this.questionMark + this.query + this.hashSign + this.fragment + this.trailingJunk;
    }

    static String ssurtHost(String host) {
        if (host.isEmpty()) {
            return host;
        }
        if (host.charAt(0) == '[') {
            return host;
        }
        if (IpAddresses.parseIpv4(host) != -1L) {
            return host;
        }
        return ParsedUrl.reverseHost(host);
    }

    static String reverseHost(String host) {
        StringBuilder buf = new StringBuilder(host.length() + 1);
        String nocommas = host.replace(",", ".");
        int j = host.length();
        for (int i = host.length() - 1; i >= 0; --i) {
            if (host.charAt(i) != '.') continue;
            buf.append(nocommas, i + 1, j);
            buf.append(',');
            j = i;
        }
        buf.append(nocommas, 0, j);
        buf.append(',');
        return buf.toString();
    }

    String hostPort() {
        return this.host + this.colonBeforePort + this.port;
    }

    public String getLeadingJunk() {
        return this.leadingJunk;
    }

    public void setLeadingJunk(String leadingJunk) {
        this.leadingJunk = Objects.requireNonNull(leadingJunk);
    }

    public String getTrailingJunk() {
        return this.trailingJunk;
    }

    public void setTrailingJunk(String trailingJunk) {
        this.trailingJunk = Objects.requireNonNull(trailingJunk);
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = Objects.requireNonNull(scheme);
    }

    public String getColonAfterScheme() {
        return this.colonAfterScheme;
    }

    public void setColonAfterScheme(String colonAfterScheme) {
        this.colonAfterScheme = Objects.requireNonNull(colonAfterScheme);
    }

    public String getQuestionMark() {
        return this.questionMark;
    }

    public void setQuestionMark(String questionMark) {
        this.questionMark = Objects.requireNonNull(questionMark);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = Objects.requireNonNull(query);
    }

    public String getHashSign() {
        return this.hashSign;
    }

    public void setHashSign(String hashSign) {
        this.hashSign = Objects.requireNonNull(hashSign);
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(String fragment) {
        this.fragment = Objects.requireNonNull(fragment);
    }

    public String getSlashes() {
        return this.slashes;
    }

    public void setSlashes(String slashes) {
        this.slashes = Objects.requireNonNull(slashes);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = Objects.requireNonNull(path);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = Objects.requireNonNull(username);
    }

    public String getColonBeforePassword() {
        return this.colonBeforePassword;
    }

    public void setColonBeforePassword(String colonBeforePassword) {
        this.colonBeforePassword = Objects.requireNonNull(colonBeforePassword);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = Objects.requireNonNull(password);
    }

    public String getAtSign() {
        return this.atSign;
    }

    public void setAtSign(String atSign) {
        this.atSign = Objects.requireNonNull(atSign);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = Objects.requireNonNull(host);
    }

    public String getColonBeforePort() {
        return this.colonBeforePort;
    }

    public void setColonBeforePort(String colonBeforePort) {
        this.colonBeforePort = Objects.requireNonNull(colonBeforePort);
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = Objects.requireNonNull(port);
    }

    public ParsedUrl resolve(ParsedUrl relative) {
        return new ParsedUrl(this, relative);
    }
}

