/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.urlcanon;

import org.netpreserve.urlcanon.CharSequences;

class IpAddresses {
    IpAddresses() {
    }

    static String formatIpv4(long ipv4) {
        if (ipv4 < 0L) {
            throw new IllegalArgumentException("value " + ipv4);
        }
        return String.format("%d.%d.%d.%d", ipv4 >> 24, ipv4 >> 16 & 0xFFL, ipv4 >> 8 & 0xFFL, ipv4 & 0xFFL);
    }

    static short[] parseIpv6(String host) {
        short[] addr = new short[8];
        String[] groups = host.split(":", 10);
        if (groups.length < 3 || groups.length > 9) {
            return null;
        }
        boolean hasIp4 = groups[groups.length - 1].indexOf(46) != -1;
        boolean seenDoubleColon = false;
        int j = 0;
        for (int i = 0; i < groups.length; ++i) {
            String group = groups[i];
            if (group.isEmpty()) {
                if (seenDoubleColon) {
                    return null;
                }
                seenDoubleColon = true;
                if (i == 0) {
                    if (groups[1].isEmpty()) {
                        ++i;
                    } else {
                        return null;
                    }
                }
                if (i == groups.length - 2 && groups[i + 1].isEmpty()) {
                    ++i;
                }
                j = addr.length - (groups.length - i) + 1;
                if (!hasIp4) continue;
                --j;
                continue;
            }
            if (i == groups.length - 1 && hasIp4) {
                if (j != 6) {
                    return null;
                }
                long ip4 = IpAddresses.parseIpv4(group);
                if (ip4 == -1L) {
                    return null;
                }
                addr[6] = (short)(ip4 >>> 16);
                addr[7] = (short)ip4;
                return addr;
            }
            long value = CharSequences.parseUnsignedLongNoThrow(group, 0, group.length(), 16);
            if (value == -1L) {
                return null;
            }
            if (j >= addr.length) {
                return null;
            }
            addr[j++] = (short)value;
        }
        if (!seenDoubleColon && groups.length != 8) {
            return null;
        }
        return addr;
    }

    static String formatIpv6(short[] addr) {
        int i;
        int zeroesStart = addr.length;
        int zeroesLen = 0;
        int curStart = 0;
        int curLen = 0;
        for (int i2 = 0; i2 < addr.length; ++i2) {
            if (addr[i2] == 0) {
                if (curLen == 0) {
                    curStart = i2;
                }
                ++curLen;
                continue;
            }
            if (curLen > 1 && curLen > zeroesLen) {
                zeroesLen = curLen;
                zeroesStart = curStart;
            }
            curLen = 0;
        }
        if (curLen > 1 && curLen > zeroesLen) {
            zeroesLen = curLen;
            zeroesStart = curStart;
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < zeroesStart; ++i) {
            sb.append(Integer.toHexString(addr[i] & 0xFFFF));
            if (i >= addr.length - 1) continue;
            sb.append(':');
        }
        if (zeroesStart == 0) {
            sb.append(':');
        }
        for (i = zeroesStart + zeroesLen; i < addr.length; ++i) {
            sb.append(':').append(Integer.toHexString(addr[i] & 0xFFFF));
        }
        if (zeroesLen > 0 && zeroesStart + zeroesLen == addr.length) {
            sb.append(':');
        }
        return sb.toString();
    }

    static long parseIpv4(String host) {
        long ipv4 = 0L;
        int startOfPart = 0;
        if (host.isEmpty()) {
            return -1L;
        }
        int i = 0;
        while (true) {
            long part;
            int endOfPart;
            if ((endOfPart = host.indexOf(".", startOfPart)) == -1) {
                endOfPart = host.length();
            }
            if (i >= 4) {
                return -1L;
            }
            if (startOfPart == endOfPart) {
                part = 0L;
            } else {
                part = IpAddresses.parseIpv4Num(host, startOfPart, endOfPart);
                if (part == -1L) {
                    return -1L;
                }
            }
            if (endOfPart >= host.length() - 1) {
                if (part >= 1L << 8 * (4 - i)) {
                    return -1L;
                }
                ipv4 <<= 8 * (4 - i);
                return ipv4 += part;
            }
            if (part > 255L) {
                return -1L;
            }
            ipv4 = ipv4 * 256L + part;
            startOfPart = endOfPart + 1;
            ++i;
        }
    }

    private static long parseIpv4Num(String host, int start, int end) {
        int radix = 10;
        if (end - start >= 2 && host.charAt(start) == '0') {
            char c = host.charAt(start + 1);
            if (c == 'x' || c == 'X') {
                radix = 16;
                start += 2;
            } else {
                radix = 8;
                ++start;
            }
        }
        return CharSequences.parseUnsignedLongNoThrow(host, start, end, radix);
    }
}

