/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.urlcanon;

import java.util.Locale;
import java.util.regex.Pattern;
import org.netpreserve.urlcanon.Canonicalizer;
import org.netpreserve.urlcanon.ParsedUrl;
import org.netpreserve.urlcanon.SemanticPreciseCanonicalizer;

public class AggressiveCanonicalizer
implements Canonicalizer {
    private static final Pattern WWW_RE = Pattern.compile("^www[0-9]*\\.");
    private static final Pattern QUERY_SESSIONID_RE = Pattern.compile("(?i)(?<=&|^)(?:jsessionid=[0-9a-z$]{10,}|sessionid=[0-9a-z]{16,}|phpsessid=[0-9a-z]{16,}|sid=[0-9a-z]{16,}|aspsessionid[a-z]{8}=[0-9a-z]{16,}|cfid=[0-9]+&cftoken=[0-9a-z-]+)(?:&|$)");
    private static final Pattern ASPX_SUFFIX_RE = Pattern.compile(".*\\.aspx$");
    private static final Pattern ASPX_PATH_SESSIONID_RE = Pattern.compile("(?<=/)\\([0-9a-z]{24}\\)/|(?<=/)(?:\\((?:[a-z]\\([0-9a-z]{24}\\))+\\)/)");
    private static final Pattern PATH_SESSIONID_RE = Pattern.compile(";jsessionid=[0-9a-z]{32}$");

    @Override
    public void canonicalize(ParsedUrl url) {
        Canonicalizer.SEMANTIC.canonicalize(url);
        AggressiveCanonicalizer.httpsToHttp(url);
        AggressiveCanonicalizer.stripWww(url);
        AggressiveCanonicalizer.lowercasePath(url);
        AggressiveCanonicalizer.lowercaseQuery(url);
        AggressiveCanonicalizer.stripSessionIdsFromQuery(url);
        AggressiveCanonicalizer.stripSessionIdsFromPath(url);
        AggressiveCanonicalizer.stripTrailingSlashUnlessEmpty(url);
        AggressiveCanonicalizer.removeRedundantAmpersandsFromQuery(url);
        this.omitQuestionMarkIfQueryEmpty(url);
        SemanticPreciseCanonicalizer.alphaReorderQuery(url);
    }

    static void httpsToHttp(ParsedUrl url) {
        if (url.getScheme().equalsIgnoreCase("https")) {
            url.setScheme("http");
        }
    }

    static void stripWww(ParsedUrl url) {
        url.setHost(WWW_RE.matcher(url.getHost()).replaceAll(""));
    }

    static void lowercasePath(ParsedUrl url) {
        url.setPath(url.getPath().toLowerCase(Locale.US));
    }

    static void lowercaseQuery(ParsedUrl url) {
        url.setQuery(url.getQuery().toLowerCase(Locale.US));
    }

    static void stripSessionIdsFromQuery(ParsedUrl url) {
        url.setQuery(QUERY_SESSIONID_RE.matcher(url.getQuery()).replaceAll(""));
    }

    static void stripSessionIdsFromPath(ParsedUrl url) {
        String path = url.getPath();
        if (ASPX_SUFFIX_RE.matcher(path).matches()) {
            path = ASPX_PATH_SESSIONID_RE.matcher(path).replaceAll("");
        }
        path = PATH_SESSIONID_RE.matcher(path).replaceAll("");
        url.setPath(path);
    }

    static void removeRedundantAmpersandsFromQuery(ParsedUrl url) {
        url.setQuery(SemanticPreciseCanonicalizer.removeLeadingTrailingAndDuplicateChars(url.getQuery(), '&'));
    }

    private static void stripTrailingSlashUnlessEmpty(ParsedUrl url) {
        String path = url.getPath();
        if (path.length() > 1 && path.charAt(path.length() - 1) == '/') {
            url.setPath(path.substring(0, path.length() - 1));
        }
    }

    private void omitQuestionMarkIfQueryEmpty(ParsedUrl url) {
        if (url.getQuery().isEmpty()) {
            url.setQuestionMark("");
        }
    }
}

