/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.urlcanon;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netpreserve.urlcanon.Canonicalizer;
import org.netpreserve.urlcanon.CharSequences;
import org.netpreserve.urlcanon.Idn;
import org.netpreserve.urlcanon.IpAddresses;
import org.netpreserve.urlcanon.ParsedUrl;

class WhatwgCanonicalizer
implements Canonicalizer {
    private static final String SLASH = "/";
    private static final String TWO_SLASHES = "//";
    private static final Pattern SPECIAL_PATH_SEGMENT_REGEX = Pattern.compile("(?:([.]|%2e)([.]|%2e)?|[^/\\\\]*)(?:[/\\\\]|\\Z)", 2);
    private static final Pattern NONSPECIAL_PATH_SEGMENT_REGEX = Pattern.compile("(?:([.]|%2e)([.]|%2e)?|[^/]*)(?:/|\\Z)", 2);
    private static final boolean[] C0_ENCODE = WhatwgCanonicalizer.buildEncodeSet("[\\x00-\\x1f\\x7f-\\xff]");
    private static final boolean[] PATH_ENCODE = WhatwgCanonicalizer.buildEncodeSet("[\\x00-\\x20\\x7f-\\xff\"#<>?`{}]");
    private static final boolean[] QUERY_ENCODE = WhatwgCanonicalizer.buildEncodeSet("[\\x00-\\x20\\x22\\x23\\x3c\\x3e\\x7f-\\xff]");
    private static final boolean[] USERINFO_ENCODE = WhatwgCanonicalizer.buildEncodeSet("[\\x00-\\x20\\x7f-\\xff\"#<>?`{}/:;=@\\x5b\\x5c\\x5d\\x5e\\x7c]");
    private static final boolean[] HOST_ENCODE = WhatwgCanonicalizer.buildEncodeSet("[\\x00-\\x20\\x7f-\\xff]");
    private static final Idn idn = Idn.load();

    WhatwgCanonicalizer() {
    }

    static boolean[] buildEncodeSet(String regex) {
        boolean[] array = new boolean[256];
        Pattern pattern = Pattern.compile(regex);
        for (int i = 0; i < 256; ++i) {
            array[i] = pattern.matcher(Character.toString((char)i)).matches();
        }
        return array;
    }

    static String removeTabsAndNewlines(String s) {
        int first = WhatwgCanonicalizer.findTabOrNewline(s);
        if (first == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        sb.append(s, 0, first);
        for (int j = first; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (c == '\t' || c == '\r' || c == '\n') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static int findTabOrNewline(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\t' && c != '\r' && c != '\n') continue;
            return i;
        }
        return -1;
    }

    static void removeLeadingTrailingJunk(ParsedUrl url) {
        url.setLeadingJunk("");
        url.setTrailingJunk("");
    }

    static void removeTabsAndNewlines(ParsedUrl url) {
        url.setLeadingJunk(WhatwgCanonicalizer.removeTabsAndNewlines(url.getLeadingJunk()));
        url.setScheme(WhatwgCanonicalizer.removeTabsAndNewlines(url.getScheme()));
        url.setColonAfterScheme(WhatwgCanonicalizer.removeTabsAndNewlines(url.getColonAfterScheme()));
        url.setSlashes(WhatwgCanonicalizer.removeTabsAndNewlines(url.getSlashes()));
        url.setUsername(WhatwgCanonicalizer.removeTabsAndNewlines(url.getUsername()));
        url.setColonBeforePassword(WhatwgCanonicalizer.removeTabsAndNewlines(url.getColonBeforePassword()));
        url.setPassword(WhatwgCanonicalizer.removeTabsAndNewlines(url.getPassword()));
        url.setAtSign(WhatwgCanonicalizer.removeTabsAndNewlines(url.getAtSign()));
        url.setHost(WhatwgCanonicalizer.removeTabsAndNewlines(url.getHost()));
        url.setColonBeforePort(WhatwgCanonicalizer.removeTabsAndNewlines(url.getColonBeforePort()));
        url.setPort(WhatwgCanonicalizer.removeTabsAndNewlines(url.getPort()));
        url.setPath(WhatwgCanonicalizer.removeTabsAndNewlines(url.getPath()));
        url.setQuestionMark(WhatwgCanonicalizer.removeTabsAndNewlines(url.getQuestionMark()));
        url.setQuery(WhatwgCanonicalizer.removeTabsAndNewlines(url.getQuery()));
        url.setHashSign(WhatwgCanonicalizer.removeTabsAndNewlines(url.getHashSign()));
        url.setFragment(WhatwgCanonicalizer.removeTabsAndNewlines(url.getFragment()));
        url.setTrailingJunk(WhatwgCanonicalizer.removeTabsAndNewlines(url.getTrailingJunk()));
    }

    static void lowercaseScheme(ParsedUrl url) {
        url.setScheme(url.getScheme().toLowerCase(Locale.US));
    }

    static void fixBackslashes(ParsedUrl url) {
        if (ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme())) {
            char c;
            url.setSlashes(url.getSlashes().replace('\\', '/'));
            String path = url.getPath();
            if (!(path.isEmpty() || (c = path.charAt(0)) != '/' && c != '\\')) {
                url.setPath(path.replace('\\', '/'));
            }
        }
    }

    static String resolvePathDots(String path, boolean special) {
        if (!path.isEmpty() && (path.charAt(0) == '/' || special && path.charAt(0) == '\\')) {
            if (!(path.contains("/.") || path.contains("/%2") || special && (path.contains("\\.") || path.contains("\\%2")))) {
                return path;
            }
            StringBuilder buf = new StringBuilder(path.length());
            buf.append(path.charAt(0));
            ArrayDeque<Integer> segmentOffsets = new ArrayDeque<Integer>();
            Matcher m = (special ? SPECIAL_PATH_SEGMENT_REGEX : NONSPECIAL_PATH_SEGMENT_REGEX).matcher(path);
            m.region(1, path.length());
            while (m.lookingAt()) {
                if (m.start(2) != -1) {
                    buf.setLength(segmentOffsets.isEmpty() ? 1 : (Integer)segmentOffsets.pop());
                } else if (m.start(1) == -1) {
                    segmentOffsets.push(buf.length());
                    buf.append(path, m.start(), m.end());
                }
                if (m.end() == path.length()) break;
                m.region(m.end(), path.length());
            }
            return buf.toString();
        }
        return path;
    }

    static void normalizePathDots(ParsedUrl url) {
        url.setPath(WhatwgCanonicalizer.resolvePathDots(url.getPath(), ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme())));
    }

    public static String pctDecode(String str, Charset charset) {
        if (str.indexOf(37) == -1) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        byte[] buf = new byte[16];
        int len = 0;
        int i = 0;
        while (i < str.length()) {
            int digit2;
            int digit1;
            while (i + 3 <= str.length() && str.charAt(i) == '%' && (digit1 = Character.digit(str.charAt(i + 1), 16)) != -1 && (digit2 = Character.digit(str.charAt(i + 2), 16)) != -1) {
                if (len >= buf.length) {
                    buf = Arrays.copyOf(buf, buf.length * 2);
                }
                buf[len++] = (byte)(digit1 << 4 | digit2);
                i += 3;
            }
            if (len > 0) {
                sb.append(new String(buf, 0, len, charset));
                len = 0;
                continue;
            }
            sb.append(str.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    private static boolean isHexDigit(char c) {
        return c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    static String pctEncode(String str, boolean[] encodeSet, Charset charset) {
        int len;
        StringBuilder buf = null;
        for (int i = 0; i < str.length(); i += len) {
            int codepoint = str.codePointAt(i);
            len = Character.charCount(codepoint);
            if (codepoint > 255 || encodeSet[codepoint]) {
                byte[] encoded;
                if (buf == null) {
                    buf = new StringBuilder(str.length());
                    buf.append(str, 0, i);
                }
                for (byte b : encoded = str.substring(i, i + len).getBytes(charset)) {
                    buf.append('%');
                    buf.append(Character.toUpperCase(Character.forDigit((b & 0xFF) >> 4, 16)));
                    buf.append(Character.toUpperCase(Character.forDigit(b & 0xF, 16)));
                }
                continue;
            }
            if (buf == null) continue;
            buf.append(str, i, i + len);
        }
        return buf == null ? str : buf.toString();
    }

    void pctEncodePath(ParsedUrl url, Charset charset) {
        boolean[] encodeSet = !url.getPath().isEmpty() && url.getPath().charAt(0) == '/' || ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme()) ? PATH_ENCODE : C0_ENCODE;
        url.setPath(WhatwgCanonicalizer.pctEncode(url.getPath(), encodeSet, charset));
    }

    void pctEncodeFragment(ParsedUrl url, Charset charset) {
        url.setFragment(WhatwgCanonicalizer.pctEncode(url.getFragment(), C0_ENCODE, charset));
    }

    void pctEncodeQuery(ParsedUrl url, Charset charset) {
        url.setQuery(WhatwgCanonicalizer.pctEncode(url.getQuery(), QUERY_ENCODE, charset));
    }

    static void emptyPathToSlash(ParsedUrl url) {
        if (url.getPath().isEmpty() && !url.getHost().isEmpty() && ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme())) {
            url.setPath(SLASH);
        }
    }

    static void elideDefaultPort(ParsedUrl url) {
        if (WhatwgCanonicalizer.hasDefaultPort(url)) {
            url.setColonBeforePort("");
            url.setPort("");
        }
    }

    private static boolean hasDefaultPort(ParsedUrl url) {
        Integer defaultPort = ParsedUrl.SPECIAL_SCHEMES.get(url.getScheme());
        int port = (int)CharSequences.parseLong(url.getPort());
        return defaultPort != null && port == defaultPort;
    }

    static String normalizeIpAddress(String host) {
        if (host.startsWith("[") && host.endsWith("]")) {
            short[] ipv6 = IpAddresses.parseIpv6(host.substring(1, host.length() - 1));
            if (ipv6 == null) {
                return host;
            }
            return "[" + IpAddresses.formatIpv6(ipv6) + "]";
        }
        long ipv4 = IpAddresses.parseIpv4(host);
        if (ipv4 != -1L) {
            return IpAddresses.formatIpv4(ipv4);
        }
        return host;
    }

    public static void normalizeIpAddress(ParsedUrl url) {
        url.setHost(WhatwgCanonicalizer.normalizeIpAddress(url.getHost()));
    }

    public static void cleanUpUserinfo(ParsedUrl url) {
        if (url.getPassword().isEmpty()) {
            url.setColonBeforePassword("");
            if (url.getUsername().isEmpty()) {
                url.setAtSign("");
            }
        }
        if (url.getUsername().isEmpty() && url.getColonBeforePassword().isEmpty() && url.getPassword().isEmpty()) {
            url.setAtSign("");
        }
    }

    public static void leadingSlash(ParsedUrl url) {
        String path = url.getPath();
        if (ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme()) && (path.isEmpty() || path.charAt(0) != '/')) {
            StringBuilder b = new StringBuilder(path.length() + 1);
            b.append('/');
            b.append(path);
            url.setPath(b.toString());
        }
    }

    public static void twoSlashes(ParsedUrl url) {
        if (!url.getSlashes().isEmpty() || ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme())) {
            url.setSlashes(TWO_SLASHES);
        }
    }

    public static void punycodeSpecialHost(ParsedUrl url, Charset charset) {
        if (ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme())) {
            String host = url.getHost();
            if (charset != StandardCharsets.UTF_8 && (host = new String(host.getBytes(charset), StandardCharsets.UTF_8)).contains("\ufffd")) {
                return;
            }
            try {
                String ascii = idn.toAscii(host);
                url.setHost(ascii.toLowerCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    static void pctEncodeHost(ParsedUrl url, Charset charset) {
        url.setHost(WhatwgCanonicalizer.pctEncode(url.getHost(), HOST_ENCODE, charset));
    }

    static void pctDecodeHost(ParsedUrl url, Charset charset) {
        if (ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme())) {
            url.setHost(WhatwgCanonicalizer.pctDecode(url.getHost(), charset));
        }
    }

    static void pctEncodeUserinfo(ParsedUrl url, Charset charset) {
        url.setUsername(WhatwgCanonicalizer.pctEncode(url.getUsername(), USERINFO_ENCODE, charset));
        url.setPassword(WhatwgCanonicalizer.pctEncode(url.getPassword(), USERINFO_ENCODE, charset));
    }

    @Override
    public void canonicalize(ParsedUrl url) {
        this.canonicalize(url, StandardCharsets.UTF_8);
    }

    public void canonicalize(ParsedUrl url, Charset charset) {
        WhatwgCanonicalizer.removeLeadingTrailingJunk(url);
        WhatwgCanonicalizer.removeTabsAndNewlines(url);
        WhatwgCanonicalizer.lowercaseScheme(url);
        WhatwgCanonicalizer.elideDefaultPort(url);
        WhatwgCanonicalizer.cleanUpUserinfo(url);
        WhatwgCanonicalizer.twoSlashes(url);
        WhatwgCanonicalizer.pctDecodeHost(url, charset);
        WhatwgCanonicalizer.normalizeIpAddress(url);
        WhatwgCanonicalizer.punycodeSpecialHost(url, charset);
        WhatwgCanonicalizer.pctEncodeHost(url, charset);
        WhatwgCanonicalizer.fixBackslashes(url);
        this.pctEncodePath(url, charset);
        WhatwgCanonicalizer.elideDefaultPort(url);
        WhatwgCanonicalizer.leadingSlash(url);
        WhatwgCanonicalizer.normalizePathDots(url);
        WhatwgCanonicalizer.emptyPathToSlash(url);
        WhatwgCanonicalizer.pctEncodeUserinfo(url, charset);
        this.pctEncodeQuery(url, charset);
        this.pctEncodeFragment(url, charset);
    }
}

