/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.urlcanon;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.netpreserve.urlcanon.IpAddresses;
import org.netpreserve.urlcanon.UrlParser;

public class ParsedUrl {
    static final Map<String, Integer> SPECIAL_SCHEMES = ParsedUrl.initSpecialSchemes();
    private String leadingJunk;
    private String trailingJunk;
    private String scheme;
    private String colonAfterScheme;
    private String questionMark;
    private String query;
    private String hashSign;
    private String fragment;
    private String slashes;
    private String path;
    private String username;
    private String colonBeforePassword;
    private String password;
    private String atSign;
    private String host;
    private String colonBeforePort;
    private String port;

    private static Map<String, Integer> initSpecialSchemes() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("ftp", 21);
        map.put("gopher", 70);
        map.put("http", 80);
        map.put("https", 443);
        map.put("ws", 80);
        map.put("wss", 443);
        map.put("file", null);
        return map;
    }

    ParsedUrl() {
    }

    private ParsedUrl(ParsedUrl base, ParsedUrl relative) {
        this.leadingJunk = relative.leadingJunk;
        this.trailingJunk = relative.trailingJunk;
        this.scheme = relative.scheme;
        this.colonAfterScheme = relative.colonAfterScheme;
        this.questionMark = relative.questionMark;
        this.query = relative.query;
        this.hashSign = relative.hashSign;
        this.fragment = relative.fragment;
        this.slashes = relative.slashes;
        this.path = relative.path;
        this.username = relative.username;
        this.colonBeforePassword = relative.colonBeforePassword;
        this.password = relative.password;
        this.atSign = relative.atSign;
        this.host = relative.host;
        this.colonBeforePort = relative.colonBeforePort;
        this.port = relative.port;
        if (!this.slashes.isEmpty()) {
            if (this.scheme.isEmpty()) {
                this.scheme = base.scheme;
            }
            return;
        }
        if (!this.scheme.isEmpty() && !this.scheme.equalsIgnoreCase(base.scheme)) {
            return;
        }
        if (this.scheme.isEmpty() || this.scheme.equalsIgnoreCase(base.scheme)) {
            this.scheme = base.scheme;
            this.colonAfterScheme = base.colonAfterScheme;
            this.username = base.username;
            this.colonBeforePassword = base.colonBeforePassword;
            this.password = base.password;
            this.atSign = base.atSign;
            this.host = base.host;
            this.colonBeforePort = base.colonBeforePort;
            this.port = base.port;
        }
        if (this.path.isEmpty() && !relative.host.isEmpty()) {
            this.path = relative.host;
        }
        if (this.path.isEmpty() || this.path.charAt(0) == '/') {
            return;
        }
        String dirname = base.dirname();
        StringBuilder builder = new StringBuilder(dirname.length() + this.path.length());
        builder.append(dirname);
        builder.append(this.path);
        this.path = builder.toString();
    }

    private String dirname() {
        for (int i = this.path.length() - 1; i >= 0; --i) {
            if (this.path.charAt(i) != '/') continue;
            return this.path.substring(0, i + 1);
        }
        return "";
    }

    public static ParsedUrl parseUrl(byte[] bytes) {
        return ParsedUrl.parseUrl(new String(bytes));
    }

    public static ParsedUrl parseUrl(String input) {
        return UrlParser.parseUrl(input);
    }

    public String toString() {
        return this.leadingJunk + this.scheme + this.colonAfterScheme + this.slashes + this.username + this.colonBeforePassword + this.password + this.atSign + this.host + this.colonBeforePort + this.port + this.path + this.questionMark + this.query + this.hashSign + this.fragment + this.trailingJunk;
    }

    public String ssurt() {
        String ssurtHost = ParsedUrl.ssurtHost(this.host);
        StringBuilder builder = new StringBuilder(this.leadingJunk.length() + this.scheme.length() + this.colonAfterScheme.length() + this.slashes.length() + this.username.length() + this.colonBeforePassword.length() + this.password.length() + this.atSign.length() + ssurtHost.length() + this.colonBeforePort.length() + this.port.length() + this.path.length() + this.questionMark.length() + this.query.length() + this.hashSign.length() + this.fragment.length() + this.trailingJunk.length());
        builder.append(this.leadingJunk);
        builder.append(ssurtHost);
        builder.append(this.slashes);
        builder.append(this.port);
        builder.append(this.colonBeforePort);
        builder.append(this.scheme);
        builder.append(this.atSign);
        builder.append(this.username);
        builder.append(this.colonBeforePassword);
        builder.append(this.password);
        builder.append(this.colonAfterScheme);
        builder.append(this.path);
        builder.append(this.questionMark);
        builder.append(this.query);
        builder.append(this.hashSign);
        builder.append(this.fragment);
        builder.append(this.trailingJunk);
        return builder.toString();
    }

    static String ssurtHost(String host) {
        if (host.isEmpty()) {
            return host;
        }
        if (host.charAt(0) == '[') {
            return host;
        }
        if (IpAddresses.parseIpv4(host) != -1L) {
            return host;
        }
        return ParsedUrl.reverseHost(host);
    }

    static String reverseHost(String host) {
        StringBuilder buf = new StringBuilder(host.length() + 1);
        String nocommas = host.replace(",", ".");
        int j = host.length();
        for (int i = host.length() - 1; i >= 0; --i) {
            if (host.charAt(i) != '.') continue;
            buf.append(nocommas, i + 1, j);
            buf.append(',');
            j = i;
        }
        buf.append(nocommas, 0, j);
        buf.append(',');
        return buf.toString();
    }

    String hostPort() {
        StringBuilder builder = new StringBuilder(this.host.length() + this.colonBeforePort.length() + this.port.length());
        builder.append(this.host);
        builder.append(this.colonBeforePort);
        builder.append(this.port);
        return builder.toString();
    }

    public String getLeadingJunk() {
        return this.leadingJunk;
    }

    public void setLeadingJunk(String leadingJunk) {
        this.leadingJunk = Objects.requireNonNull(leadingJunk);
    }

    public String getTrailingJunk() {
        return this.trailingJunk;
    }

    public void setTrailingJunk(String trailingJunk) {
        this.trailingJunk = Objects.requireNonNull(trailingJunk);
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = Objects.requireNonNull(scheme);
    }

    public String getColonAfterScheme() {
        return this.colonAfterScheme;
    }

    public void setColonAfterScheme(String colonAfterScheme) {
        this.colonAfterScheme = Objects.requireNonNull(colonAfterScheme);
    }

    public String getQuestionMark() {
        return this.questionMark;
    }

    public void setQuestionMark(String questionMark) {
        this.questionMark = Objects.requireNonNull(questionMark);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = Objects.requireNonNull(query);
    }

    public String getHashSign() {
        return this.hashSign;
    }

    public void setHashSign(String hashSign) {
        this.hashSign = Objects.requireNonNull(hashSign);
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(String fragment) {
        this.fragment = Objects.requireNonNull(fragment);
    }

    public String getSlashes() {
        return this.slashes;
    }

    public void setSlashes(String slashes) {
        this.slashes = Objects.requireNonNull(slashes);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = Objects.requireNonNull(path);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = Objects.requireNonNull(username);
    }

    public String getColonBeforePassword() {
        return this.colonBeforePassword;
    }

    public void setColonBeforePassword(String colonBeforePassword) {
        this.colonBeforePassword = Objects.requireNonNull(colonBeforePassword);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = Objects.requireNonNull(password);
    }

    public String getAtSign() {
        return this.atSign;
    }

    public void setAtSign(String atSign) {
        this.atSign = Objects.requireNonNull(atSign);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = Objects.requireNonNull(host);
    }

    public String getColonBeforePort() {
        return this.colonBeforePort;
    }

    public void setColonBeforePort(String colonBeforePort) {
        this.colonBeforePort = Objects.requireNonNull(colonBeforePort);
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = Objects.requireNonNull(port);
    }

    public ParsedUrl resolve(ParsedUrl relative) {
        return new ParsedUrl(this, relative);
    }
}

