/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.urlcanon;

import org.netpreserve.urlcanon.CharSequences;

class IpAddresses {
    IpAddresses() {
    }

    static String formatIpv4(long ipv4) {
        if (ipv4 < 0L) {
            throw new IllegalArgumentException("value " + ipv4);
        }
        return String.format("%d.%d.%d.%d", ipv4 >> 24, ipv4 >> 16 & 0xFFL, ipv4 >> 8 & 0xFFL, ipv4 & 0xFFL);
    }

    static long parseIpv4(CharSequence host) {
        long ipv4 = 0L;
        int startOfPart = 0;
        int i = 0;
        while (true) {
            int endOfPart;
            if ((endOfPart = CharSequences.indexOf(host, '.', startOfPart)) == -1) {
                endOfPart = host.length();
            }
            if (startOfPart == endOfPart || i >= 4) {
                return -1L;
            }
            long part = IpAddresses.parseIpv4Num(host, startOfPart, endOfPart);
            if (part == -1L) {
                return -1L;
            }
            if (endOfPart >= host.length() - 1) {
                if (part >= 1L << 8 * (4 - i)) {
                    return -1L;
                }
                ipv4 <<= 8 * (4 - i);
                return ipv4 += part;
            }
            if (part > 255L) {
                return -1L;
            }
            ipv4 = ipv4 * 256L + part;
            startOfPart = endOfPart + 1;
            ++i;
        }
    }

    private static long parseIpv4Num(CharSequence host, int start, int end) {
        int radix = 10;
        if (end - start >= 2 && host.charAt(start) == '0') {
            char c = host.charAt(start + 1);
            if (c == 'x' || c == 'X') {
                radix = 16;
                start += 2;
            } else {
                radix = 8;
                ++start;
            }
        }
        return IpAddresses.parseLongFast(host, start, end, radix);
    }

    static long parseLongFast(CharSequence s, int start, int end, int radix) {
        long n = 0L;
        for (int i = start; i < end; ++i) {
            int digit = Character.digit(s.charAt(i), radix);
            if (digit == -1) {
                return -1L;
            }
            n = n * (long)radix + (long)digit;
        }
        return n;
    }
}

