/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.urlcanon;

import java.net.IDN;
import java.util.ArrayDeque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netpreserve.urlcanon.ByteString;
import org.netpreserve.urlcanon.ByteStringBuilder;
import org.netpreserve.urlcanon.Canonicalizer;
import org.netpreserve.urlcanon.CharSequences;
import org.netpreserve.urlcanon.IpAddresses;
import org.netpreserve.urlcanon.ParsedUrl;

class WhatwgCanonicalizer
implements Canonicalizer {
    private static final ByteString SLASH = new ByteString("/");
    private static final ByteString TWO_SLASHES = new ByteString("//");
    private static final Pattern SPECIAL_PATH_SEGMENT_REGEX = Pattern.compile("(?:([.]|%2e)([.]|%2e)?|[^/\\\\]*)(?:[/\\\\]|\\Z)", 2);
    private static final Pattern NONSPECIAL_PATH_SEGMENT_REGEX = Pattern.compile("(?:([.]|%2e)([.]|%2e)?|[^/]*)(?:/|\\Z)", 2);
    private static final Pattern C0_ENCODE_REGEX = Pattern.compile("[\\x00-\\x1f\\x7f-\\xff]");
    private static final Pattern PATH_ENCODE_REGEX = Pattern.compile("[\\x00-\\x20\\x7f-\\xff\"#<>?`{}]");
    private static final Pattern QUERY_ENCODE_REGEX = Pattern.compile("[\\x00-\\x20\\x22\\x23\\x3c\\x3e\\x7f-\\xff]");
    private static final Pattern USERINFO_ENCODE_REGEX = Pattern.compile("[\\x00-\\x20\\x7f-\\xff\"#<>?`{}/:;=@\\x5b\\x5c\\x5d\\x5e\\x7c]");
    private static final Pattern TAB_AND_NEWLINE_REGEX = Pattern.compile("[\\x09\\x0a\\x0d]");
    protected static Pattern PCT_DECODE_REGEX = Pattern.compile("%([0-9a-fA-F]{2})");

    WhatwgCanonicalizer() {
    }

    static ByteString removeTabsAndNewlines(ByteString s) {
        return s.replaceAll(TAB_AND_NEWLINE_REGEX, ByteString.EMPTY);
    }

    static void removeLeadingTrailingJunk(ParsedUrl url) {
        url.setLeadingJunk(ByteString.EMPTY);
        url.setTrailingJunk(ByteString.EMPTY);
    }

    static void removeTabsAndNewlines(ParsedUrl url) {
        url.setLeadingJunk(WhatwgCanonicalizer.removeTabsAndNewlines(url.getLeadingJunk()));
        url.setScheme(WhatwgCanonicalizer.removeTabsAndNewlines(url.getScheme()));
        url.setColonAfterScheme(WhatwgCanonicalizer.removeTabsAndNewlines(url.getColonAfterScheme()));
        url.setSlashes(WhatwgCanonicalizer.removeTabsAndNewlines(url.getSlashes()));
        url.setUsername(WhatwgCanonicalizer.removeTabsAndNewlines(url.getUsername()));
        url.setColonBeforePassword(WhatwgCanonicalizer.removeTabsAndNewlines(url.getColonBeforePassword()));
        url.setPassword(WhatwgCanonicalizer.removeTabsAndNewlines(url.getPassword()));
        url.setAtSign(WhatwgCanonicalizer.removeTabsAndNewlines(url.getAtSign()));
        url.setHost(WhatwgCanonicalizer.removeTabsAndNewlines(url.getHost()));
        url.setColonBeforePort(WhatwgCanonicalizer.removeTabsAndNewlines(url.getColonBeforePort()));
        url.setPort(WhatwgCanonicalizer.removeTabsAndNewlines(url.getPort()));
        url.setPath(WhatwgCanonicalizer.removeTabsAndNewlines(url.getPath()));
        url.setQuestionMark(WhatwgCanonicalizer.removeTabsAndNewlines(url.getQuestionMark()));
        url.setQuery(WhatwgCanonicalizer.removeTabsAndNewlines(url.getQuery()));
        url.setHashSign(WhatwgCanonicalizer.removeTabsAndNewlines(url.getHashSign()));
        url.setFragment(WhatwgCanonicalizer.removeTabsAndNewlines(url.getFragment()));
        url.setTrailingJunk(WhatwgCanonicalizer.removeTabsAndNewlines(url.getTrailingJunk()));
    }

    static void lowercaseScheme(ParsedUrl url) {
        url.setScheme(url.getScheme().asciiLowerCase());
    }

    static void fixBackslashes(ParsedUrl url) {
        if (ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme().toString())) {
            char c;
            url.setSlashes(url.getSlashes().replace((byte)92, (byte)47));
            ByteString path = url.getPath();
            if (!(path.isEmpty() || (c = path.charAt(0)) != '/' && c != '\\')) {
                url.setPath(path.replace((byte)92, (byte)47));
            }
        }
    }

    static ByteString resolvePathDots(ByteString path, boolean special) {
        if (!path.isEmpty() && (path.charAt(0) == '/' || special && path.charAt(0) == '\\')) {
            ByteStringBuilder buf = new ByteStringBuilder(path.length());
            buf.append(path.charAt(0));
            ArrayDeque<Integer> segmentOffsets = new ArrayDeque<Integer>();
            Matcher m = (special ? SPECIAL_PATH_SEGMENT_REGEX : NONSPECIAL_PATH_SEGMENT_REGEX).matcher(path);
            m.region(1, path.length());
            while (m.lookingAt()) {
                if (m.start(2) != -1) {
                    buf.setLength(segmentOffsets.isEmpty() ? 1 : (Integer)segmentOffsets.pop());
                } else if (m.start(1) == -1) {
                    segmentOffsets.push(buf.length());
                    buf.append(path, m.start(), m.end());
                }
                if (m.end() == path.length()) break;
                m.region(m.end(), path.length());
            }
            return buf.toByteString();
        }
        return path;
    }

    static void normalizePathDots(ParsedUrl url) {
        url.setPath(WhatwgCanonicalizer.resolvePathDots(url.getPath(), ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme().toString())));
    }

    public static ByteString pctDecode(ByteString str) {
        ByteStringBuilder buf = new ByteStringBuilder(str.length());
        int pos = 0;
        Matcher m = PCT_DECODE_REGEX.matcher(str);
        while (m.find()) {
            buf.append(str, pos, m.start());
            buf.append((byte)(Integer.parseInt(m.group(1), 16) & 0xFF));
            pos = m.end();
        }
        buf.append(str, pos, str.length());
        return buf.toByteString();
    }

    static ByteString pctEncode(ByteString str, Pattern encodeSetRegex) {
        ByteStringBuilder buf = new ByteStringBuilder(str.length());
        Matcher m = encodeSetRegex.matcher(str);
        int pos = 0;
        while (m.find()) {
            buf.append(str, pos, m.start());
            buf.append('%');
            int b = str.charAt(m.start()) & 0xFF;
            buf.append(Character.toUpperCase(Character.forDigit(b >> 4, 16)));
            buf.append(Character.toUpperCase(Character.forDigit(b & 0xF, 16)));
            pos = m.end();
        }
        buf.append(str, pos, str.length());
        return buf.toByteString();
    }

    void pctEncodePath(ParsedUrl url) {
        Pattern encodeSetRegex = !url.getPath().isEmpty() && url.getPath().charAt(0) == '/' || ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme().toString()) ? PATH_ENCODE_REGEX : C0_ENCODE_REGEX;
        url.setPath(WhatwgCanonicalizer.pctEncode(url.getPath(), encodeSetRegex));
    }

    void pctEncodeFragment(ParsedUrl url) {
        url.setFragment(WhatwgCanonicalizer.pctEncode(url.getFragment(), C0_ENCODE_REGEX));
    }

    void pctEncodeQuery(ParsedUrl url) {
        url.setQuery(WhatwgCanonicalizer.pctEncode(url.getQuery(), QUERY_ENCODE_REGEX));
    }

    static void emptyPathToSlash(ParsedUrl url) {
        if (url.getPath().isEmpty() && !url.getHost().isEmpty() && ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme().toString())) {
            url.setPath(SLASH);
        }
    }

    static void elideDefaultPort(ParsedUrl url) {
        if (WhatwgCanonicalizer.hasDefaultPort(url)) {
            url.setColonBeforePort(ByteString.EMPTY);
            url.setPort(ByteString.EMPTY);
        }
    }

    private static boolean hasDefaultPort(ParsedUrl url) {
        Integer defaultPort = ParsedUrl.SPECIAL_SCHEMES.get(url.getScheme().toString());
        int port = (int)CharSequences.parseLong(url.getPort());
        return defaultPort != null && port == defaultPort;
    }

    static ByteString normalizeIpAddress(ByteString host) {
        long ipv4 = IpAddresses.parseIpv4(host);
        if (ipv4 != -1L) {
            return new ByteString(IpAddresses.formatIpv4(ipv4));
        }
        return host;
    }

    public static void normalizeIpAddress(ParsedUrl url) {
        url.setHost(WhatwgCanonicalizer.normalizeIpAddress(url.getHost()));
    }

    public static void cleanUpUserinfo(ParsedUrl url) {
        if (url.getPassword().isEmpty()) {
            url.setColonBeforePassword(ByteString.EMPTY);
            if (url.getUsername().isEmpty()) {
                url.setAtSign(ByteString.EMPTY);
            }
        }
        if (url.getUsername().isEmpty() && url.getColonBeforePassword().isEmpty() && url.getPassword().isEmpty()) {
            url.setAtSign(ByteString.EMPTY);
        }
    }

    public static void leadingSlash(ParsedUrl url) {
        ByteString path = url.getPath();
        if (ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme().toString()) && (path.isEmpty() || path.charAt(0) != '/')) {
            ByteStringBuilder b = new ByteStringBuilder(path.length() + 1);
            b.append('/');
            b.append(path);
            url.setPath(b.toByteString());
        }
    }

    public static void twoSlashes(ParsedUrl url) {
        if (!url.getSlashes().isEmpty() || ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme().toString())) {
            url.setSlashes(TWO_SLASHES);
        }
    }

    public static void punycodeSpecialHost(ParsedUrl url) {
        if (ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme().toString())) {
            String ascii = IDN.toASCII(url.getHost().toString(), 1);
            url.setHost(new ByteString(ascii.toLowerCase()));
        }
    }

    static void pctEncodeHost(ParsedUrl url) {
        url.setHost(WhatwgCanonicalizer.pctEncode(url.getHost(), C0_ENCODE_REGEX));
    }

    static void pctDecodeHost(ParsedUrl url) {
        if (ParsedUrl.SPECIAL_SCHEMES.containsKey(url.getScheme().toString())) {
            url.setHost(url.getHost().pctDecode());
        }
    }

    static void pctEncodeUserinfo(ParsedUrl url) {
        url.setUsername(WhatwgCanonicalizer.pctEncode(url.getUsername(), USERINFO_ENCODE_REGEX));
        url.setPassword(WhatwgCanonicalizer.pctEncode(url.getPassword(), USERINFO_ENCODE_REGEX));
    }

    @Override
    public void canonicalize(ParsedUrl url) {
        WhatwgCanonicalizer.removeLeadingTrailingJunk(url);
        WhatwgCanonicalizer.removeTabsAndNewlines(url);
        WhatwgCanonicalizer.lowercaseScheme(url);
        WhatwgCanonicalizer.elideDefaultPort(url);
        WhatwgCanonicalizer.cleanUpUserinfo(url);
        WhatwgCanonicalizer.twoSlashes(url);
        WhatwgCanonicalizer.pctDecodeHost(url);
        WhatwgCanonicalizer.normalizeIpAddress(url);
        WhatwgCanonicalizer.punycodeSpecialHost(url);
        WhatwgCanonicalizer.pctEncodeHost(url);
        WhatwgCanonicalizer.fixBackslashes(url);
        this.pctEncodePath(url);
        WhatwgCanonicalizer.elideDefaultPort(url);
        WhatwgCanonicalizer.leadingSlash(url);
        WhatwgCanonicalizer.normalizePathDots(url);
        WhatwgCanonicalizer.emptyPathToSlash(url);
        WhatwgCanonicalizer.pctEncodeUserinfo(url);
        this.pctEncodeQuery(url);
        this.pctEncodeFragment(url);
    }
}

