/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.urlcanon;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netpreserve.urlcanon.ByteString;
import org.netpreserve.urlcanon.ByteStringBuilder;
import org.netpreserve.urlcanon.CharSequences;
import org.netpreserve.urlcanon.IpAddresses;

public class ParsedUrl {
    private static final Pattern LEADING_JUNK_REGEX = Pattern.compile("\\A([\\x00-\\x20]*)(.*)\\Z", 32);
    private static final Pattern TRAILING_JUNK_REGEX = Pattern.compile("\\A(.*?)([\\x00-\\x20]*)\\Z", 32);
    private static final Pattern URL_REGEX = Pattern.compile("\\A(?:   ( [a-zA-Z] [^:]* )   ( : ))?(  (?: [/\\\\]* [^/\\\\?#]* )*)(?:  ( [?] )  ( [^#]* ))?(?:  ( [#] )  ( .* ))?\\Z".replace(" ", ""), 32);
    private static final int URL_GROUP_SCHEME = 1;
    private static final int URL_GROUP_COLON_AFTER_SCHEME = 2;
    private static final int URL_GROUP_PATHISH = 3;
    private static final int URL_GROUP_QUESTION_MARK = 4;
    private static final int URL_GROUP_QUERY = 5;
    private static final int URL_GROUP_HASH_SIGN = 6;
    private static final int URL_GROUP_FRAGMENT = 7;
    private static final Pattern SPECIAL_PATHISH_REGEX = Pattern.compile("( [/\\\\\\r\\n\\t]* )( [^/\\\\]* )( [/\\\\] .* )?".replace(" ", ""), 32);
    private static final Pattern NONSPECIAL_PATHISH_REGEX = Pattern.compile("( [\\r\\n\\t]* (?:/[\\r\\n\\t]*){2} )( [^/]* )( / .* )?".replace(" ", ""), 32);
    private static final Pattern FILE_PATHISH_REGEX = Pattern.compile("( [\\r\\n\\t]* (?:[/\\\\][\\r\\n\\t]*){2} )( [^/\\\\]* )( [/\\\\] .* )?".replace(" ", ""), 32);
    private static final int PATHISH_GROUP_SLASHES = 1;
    private static final int PATHISH_GROUP_HOST = 2;
    private static final int PATHISH_GROUP_AUTHORITY = 2;
    private static final int PATHISH_GROUP_PATH = 3;
    private static final Pattern AUTHORITY_REGEX = Pattern.compile("\\A(?:   ( [^:]* )   (?:     ( : )     ( .* )   )?   ( @ ))?( \\[[^]]*\\] | [^:]*  )(?:  ( : )  ( .* ))?\\Z".replace(" ", ""), 32);
    private static final int AUTHORITY_GROUP_USERNAME = 1;
    private static final int AUTHORITY_GROUP_COLON_BEFORE_PASSWORD = 2;
    private static final int AUTHORITY_GROUP_PASSWORD = 3;
    private static final int AUTHORITY_GROUP_AT_SIGN = 4;
    private static final int AUTHORITY_GROUP_HOST = 5;
    private static final int AUTHORITY_GROUP_COLON_BEFORE_PORT = 6;
    private static final int AUTHORITY_GROUP_PORT = 7;
    private static final Pattern TAB_AND_NEWLINE_REGEX = Pattern.compile("[\\x09\\x0a\\x0d]");
    static final Map<String, Integer> SPECIAL_SCHEMES = ParsedUrl.initSpecialSchemes();
    private ByteString leadingJunk;
    private ByteString trailingJunk;
    private ByteString scheme;
    private ByteString colonAfterScheme;
    private ByteString questionMark;
    private ByteString query;
    private ByteString hashSign;
    private ByteString fragment;
    private ByteString slashes;
    private ByteString path;
    private ByteString username;
    private ByteString colonBeforePassword;
    private ByteString password;
    private ByteString atSign;
    private ByteString host;
    private ByteString colonBeforePort;
    private ByteString port;

    private static Map<String, Integer> initSpecialSchemes() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("ftp", 21);
        map.put("gopher", 70);
        map.put("http", 80);
        map.put("https", 443);
        map.put("ws", 80);
        map.put("wss", 443);
        map.put("file", null);
        return map;
    }

    private ParsedUrl() {
    }

    public static ParsedUrl parseUrl(String s) {
        return ParsedUrl.parseUrl(new ByteString(s));
    }

    public static ParsedUrl parseUrl(byte[] bytes) {
        return ParsedUrl.parseUrl(new ByteString(bytes));
    }

    public static ParsedUrl parseUrl(ByteString input) {
        ParsedUrl url = new ParsedUrl();
        Matcher m = LEADING_JUNK_REGEX.matcher(input);
        if (m.matches()) {
            url.leadingJunk = CharSequences.group(input, m, 1);
            input = CharSequences.group(input, m, 2);
        } else {
            url.leadingJunk = ByteString.EMPTY;
        }
        m = TRAILING_JUNK_REGEX.matcher(input);
        if (m.matches()) {
            url.trailingJunk = CharSequences.group(input, m, 2);
            input = CharSequences.group(input, m, 1);
        } else {
            url.trailingJunk = ByteString.EMPTY;
        }
        m = URL_REGEX.matcher(input);
        if (!m.matches()) {
            throw new AssertionError((Object)"URL_REGEX didn't match");
        }
        url.scheme = CharSequences.group(input, m, 1);
        url.colonAfterScheme = CharSequences.group(input, m, 2);
        url.questionMark = CharSequences.group(input, m, 4);
        url.query = CharSequences.group(input, m, 5);
        url.hashSign = CharSequences.group(input, m, 6);
        url.fragment = CharSequences.group(input, m, 7);
        ByteString pathish = CharSequences.group(input, m, 3);
        ParsedUrl.parsePathish(url, pathish);
        return url;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void parsePathish(ParsedUrl url, ByteString pathish) {
        ByteString cleanScheme = url.scheme.replaceAll(TAB_AND_NEWLINE_REGEX, "").asciiLowerCase();
        boolean special = SPECIAL_SCHEMES.containsKey(cleanScheme.toString());
        if (cleanScheme.equalsIgnoreCase("file")) {
            Matcher m = FILE_PATHISH_REGEX.matcher(pathish);
            if (m.matches()) {
                url.slashes = CharSequences.group(pathish, m, 1);
                url.host = CharSequences.group(pathish, m, 2);
                url.path = CharSequences.group(pathish, m, 3);
            } else {
                url.slashes = ByteString.EMPTY;
                url.path = pathish;
                url.host = ByteString.EMPTY;
            }
            url.username = ByteString.EMPTY;
            url.colonBeforePassword = ByteString.EMPTY;
            url.password = ByteString.EMPTY;
            url.atSign = ByteString.EMPTY;
            url.colonBeforePort = ByteString.EMPTY;
            url.port = ByteString.EMPTY;
            return;
        } else {
            Matcher m = (special ? SPECIAL_PATHISH_REGEX : NONSPECIAL_PATHISH_REGEX).matcher(pathish);
            if (m.matches()) {
                ByteString slashes = CharSequences.group(pathish, m, 1);
                ByteString authority = CharSequences.group(pathish, m, 2);
                ByteString path = CharSequences.group(pathish, m, 3);
                url.slashes = slashes;
                url.path = path;
                m = AUTHORITY_REGEX.matcher(authority);
                if (!m.matches()) throw new AssertionError((Object)"AUTHORITY_REGEX didn't match");
                url.username = CharSequences.group(authority, m, 1);
                url.colonBeforePassword = CharSequences.group(authority, m, 2);
                url.password = CharSequences.group(authority, m, 3);
                url.atSign = CharSequences.group(authority, m, 4);
                url.host = CharSequences.group(authority, m, 5);
                url.colonBeforePort = CharSequences.group(authority, m, 6);
                url.port = CharSequences.group(authority, m, 7);
                return;
            } else {
                url.path = pathish;
                url.slashes = ByteString.EMPTY;
                url.username = ByteString.EMPTY;
                url.colonBeforePassword = ByteString.EMPTY;
                url.password = ByteString.EMPTY;
                url.atSign = ByteString.EMPTY;
                url.host = ByteString.EMPTY;
                url.colonBeforePort = ByteString.EMPTY;
                url.port = ByteString.EMPTY;
            }
        }
    }

    public byte[] toByteArray() {
        return this.buildUrl().toByteArray();
    }

    public ByteString toByteString() {
        return this.buildUrl().toByteString();
    }

    public String toString() {
        return this.buildUrl().toString();
    }

    private ByteStringBuilder buildUrl() {
        ByteStringBuilder builder = new ByteStringBuilder(this.leadingJunk.length() + this.scheme.length() + this.colonAfterScheme.length() + this.slashes.length() + this.username.length() + this.colonBeforePassword.length() + this.password.length() + this.atSign.length() + this.host.length() + this.colonBeforePort.length() + this.port.length() + this.path.length() + this.questionMark.length() + this.query.length() + this.hashSign.length() + this.fragment.length() + this.trailingJunk.length());
        builder.append(this.leadingJunk);
        builder.append(this.scheme);
        builder.append(this.colonAfterScheme);
        builder.append(this.slashes);
        builder.append(this.username);
        builder.append(this.colonBeforePassword);
        builder.append(this.password);
        builder.append(this.atSign);
        builder.append(this.host);
        builder.append(this.colonBeforePort);
        builder.append(this.port);
        builder.append(this.path);
        builder.append(this.questionMark);
        builder.append(this.query);
        builder.append(this.hashSign);
        builder.append(this.fragment);
        builder.append(this.trailingJunk);
        return builder;
    }

    public ByteString ssurt() {
        ByteString ssurtHost = ParsedUrl.ssurtHost(this.host);
        ByteStringBuilder builder = new ByteStringBuilder(this.leadingJunk.length() + this.scheme.length() + this.colonAfterScheme.length() + this.slashes.length() + this.username.length() + this.colonBeforePassword.length() + this.password.length() + this.atSign.length() + ssurtHost.length() + this.colonBeforePort.length() + this.port.length() + this.path.length() + this.questionMark.length() + this.query.length() + this.hashSign.length() + this.fragment.length() + this.trailingJunk.length());
        builder.append(this.leadingJunk);
        builder.append(ssurtHost);
        builder.append(this.slashes);
        builder.append(this.port);
        builder.append(this.colonBeforePort);
        builder.append(this.scheme);
        builder.append(this.atSign);
        builder.append(this.username);
        builder.append(this.colonBeforePassword);
        builder.append(this.password);
        builder.append(this.colonAfterScheme);
        builder.append(this.path);
        builder.append(this.questionMark);
        builder.append(this.query);
        builder.append(this.hashSign);
        builder.append(this.fragment);
        builder.append(this.trailingJunk);
        return builder.toByteString();
    }

    static ByteString ssurtHost(ByteString host) {
        if (host.isEmpty()) {
            return host;
        }
        if (host.charAt(0) == '[') {
            return host;
        }
        if (IpAddresses.parseIpv4(host) != -1L) {
            return host;
        }
        return ParsedUrl.reverseHost(host);
    }

    static ByteString reverseHost(ByteString host) {
        ByteStringBuilder buf = new ByteStringBuilder(host.length() + 1);
        ByteString nocommas = host.replace((byte)44, (byte)46);
        int j = host.length();
        for (int i = host.length() - 1; i >= 0; --i) {
            if (host.charAt(i) != '.') continue;
            buf.append(nocommas, i + 1, j);
            buf.append(',');
            j = i;
        }
        buf.append(nocommas, 0, j);
        buf.append(',');
        return buf.toByteString();
    }

    ByteString hostPort() {
        ByteStringBuilder builder = new ByteStringBuilder(this.host.length() + this.colonBeforePort.length() + this.port.length());
        builder.append(this.host);
        builder.append(this.colonBeforePort);
        builder.append(this.port);
        return builder.toByteString();
    }

    public ByteString getLeadingJunk() {
        return this.leadingJunk;
    }

    public void setLeadingJunk(ByteString leadingJunk) {
        this.leadingJunk = Objects.requireNonNull(leadingJunk);
    }

    public ByteString getTrailingJunk() {
        return this.trailingJunk;
    }

    public void setTrailingJunk(ByteString trailingJunk) {
        this.trailingJunk = Objects.requireNonNull(trailingJunk);
    }

    public ByteString getScheme() {
        return this.scheme;
    }

    public void setScheme(ByteString scheme) {
        this.scheme = Objects.requireNonNull(scheme);
    }

    public ByteString getColonAfterScheme() {
        return this.colonAfterScheme;
    }

    public void setColonAfterScheme(ByteString colonAfterScheme) {
        this.colonAfterScheme = Objects.requireNonNull(colonAfterScheme);
    }

    public ByteString getQuestionMark() {
        return this.questionMark;
    }

    public void setQuestionMark(ByteString questionMark) {
        this.questionMark = Objects.requireNonNull(questionMark);
    }

    public ByteString getQuery() {
        return this.query;
    }

    public void setQuery(ByteString query) {
        this.query = Objects.requireNonNull(query);
    }

    public ByteString getHashSign() {
        return this.hashSign;
    }

    public void setHashSign(ByteString hashSign) {
        this.hashSign = Objects.requireNonNull(hashSign);
    }

    public ByteString getFragment() {
        return this.fragment;
    }

    public void setFragment(ByteString fragment) {
        this.fragment = Objects.requireNonNull(fragment);
    }

    public ByteString getSlashes() {
        return this.slashes;
    }

    public void setSlashes(ByteString slashes) {
        this.slashes = Objects.requireNonNull(slashes);
    }

    public ByteString getPath() {
        return this.path;
    }

    public void setPath(ByteString path) {
        this.path = Objects.requireNonNull(path);
    }

    public ByteString getUsername() {
        return this.username;
    }

    public void setUsername(ByteString username) {
        this.username = Objects.requireNonNull(username);
    }

    public ByteString getColonBeforePassword() {
        return this.colonBeforePassword;
    }

    public void setColonBeforePassword(ByteString colonBeforePassword) {
        this.colonBeforePassword = Objects.requireNonNull(colonBeforePassword);
    }

    public ByteString getPassword() {
        return this.password;
    }

    public void setPassword(ByteString password) {
        this.password = Objects.requireNonNull(password);
    }

    public ByteString getAtSign() {
        return this.atSign;
    }

    public void setAtSign(ByteString atSign) {
        this.atSign = Objects.requireNonNull(atSign);
    }

    public ByteString getHost() {
        return this.host;
    }

    public void setHost(ByteString host) {
        this.host = Objects.requireNonNull(host);
    }

    public ByteString getColonBeforePort() {
        return this.colonBeforePort;
    }

    public void setColonBeforePort(ByteString colonBeforePort) {
        this.colonBeforePort = Objects.requireNonNull(colonBeforePort);
    }

    public ByteString getPort() {
        return this.port;
    }

    public void setPort(ByteString port) {
        this.port = Objects.requireNonNull(port);
    }
}

