/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.urlcanon;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.netpreserve.urlcanon.ByteString;

public class ByteStringBuilder {
    byte[] data;
    int length;

    public ByteStringBuilder(int capacity) {
        this.data = new byte[capacity];
        this.length = 0;
    }

    public ByteString toByteString() {
        return new ByteString(this.data, 0, this.length);
    }

    public ByteStringBuilder append(CharSequence s, int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("start > end");
        }
        this.ensureCapacity(this.length + (end - start));
        int j = this.length;
        for (int i = start; i < end; ++i) {
            this.data[j++] = (byte)s.charAt(i);
        }
        this.length = j;
        return this;
    }

    private void ensureCapacity(int capacity) {
        if (this.data.length < capacity) {
            this.data = Arrays.copyOf(this.data, capacity);
        }
    }

    public ByteStringBuilder append(CharSequence s) {
        this.append(s, 0, s.length());
        return this;
    }

    public String toString() {
        return new String(this.data, 0, this.length, StandardCharsets.UTF_8);
    }

    public void setLength(int length) {
        this.ensureCapacity(length);
        this.length = length;
    }

    public int length() {
        return this.length;
    }

    public void append(char c) {
        this.append((byte)(c & 0xFF));
    }

    public void append(byte b) {
        this.setLength(this.length + 1);
        this.data[this.length - 1] = b;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.data, this.length);
    }
}

