/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.urlcanon;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netpreserve.urlcanon.ByteStringBuilder;

public class ByteString
implements CharSequence,
Comparable<ByteString> {
    public static final ByteString EMPTY = new ByteString(new byte[0]);
    private final byte[] data;
    protected static Pattern PCT_DECODE_REGEX = Pattern.compile("%([0-9a-fA-F]{2})");

    public ByteString(String s) {
        this(s.getBytes(StandardCharsets.UTF_8));
    }

    public ByteString(byte[] data) {
        this(data, 0, data.length);
    }

    public ByteString(byte[] data, int off, int len) {
        this.data = Arrays.copyOfRange(data, off, off + len);
    }

    @Override
    public int length() {
        return this.data.length;
    }

    @Override
    public char charAt(int index) {
        return (char)(this.data[index] & 0xFF);
    }

    public byte byteAt(int index) {
        return (byte)(this.data[index] & 0xFF);
    }

    @Override
    public ByteString subSequence(int start, int end) {
        return new ByteString(this.data, start, end - start);
    }

    @Override
    public String toString() {
        return new String(this.data, StandardCharsets.UTF_8);
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    public static ByteString join(CharSequence delimiter, Iterable<? extends CharSequence> sequence) {
        int size = 0;
        for (CharSequence charSequence : sequence) {
            if (size > 0) {
                size += delimiter.length();
            }
            size += charSequence.length();
        }
        ByteStringBuilder builder = new ByteStringBuilder(size);
        for (CharSequence charSequence : sequence) {
            if (builder.length() > 0) {
                builder.append(delimiter);
            }
            builder.append(charSequence);
        }
        return builder.toByteString();
    }

    public ByteString replaceAll(Pattern pattern, CharSequence replacement) {
        ByteStringBuilder buf = new ByteStringBuilder(this.length());
        int pos = 0;
        Matcher m = pattern.matcher(this);
        while (m.find()) {
            buf.append(this, pos, m.start());
            buf.append(replacement);
            pos = m.end();
        }
        buf.append(this, pos, this.length());
        return buf.toByteString();
    }

    public ByteString pctDecode() {
        ByteStringBuilder buf = new ByteStringBuilder(this.length());
        int pos = 0;
        Matcher m = PCT_DECODE_REGEX.matcher(this);
        while (m.find()) {
            buf.append(this, pos, m.start());
            buf.append((byte)(Integer.parseInt(m.group(1), 16) & 0xFF));
            pos = m.end();
        }
        buf.append(this, pos, this.length());
        return buf.toByteString();
    }

    public ByteString replace(byte target, byte replacement) {
        byte[] dest = new byte[this.length()];
        for (int i = 0; i < this.data.length; ++i) {
            byte b = this.data[i];
            dest[i] = b == target ? replacement : this.data[i];
        }
        return new ByteString(dest);
    }

    private byte lowerCaseByte(byte b) {
        if (65 <= b && b <= 90) {
            return (byte)(b - 65 + 97);
        }
        return b;
    }

    public ByteString asciiLowerCase() {
        byte[] out = new byte[this.length()];
        for (int i = 0; i < this.data.length; ++i) {
            out[i] = this.lowerCaseByte(this.data[i]);
        }
        return new ByteString(out);
    }

    public boolean equalsIgnoreCase(CharSequence s) {
        int len = s.length();
        if (len != this.data.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.lowerCaseByte(this.data[i]) == this.lowerCaseByte((byte)s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(CharSequence s) {
        int len = s.length();
        if (len != this.data.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.data[i] == (byte)s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ByteString other) {
        for (int i = 0; i < this.length() && i < other.length(); ++i) {
            int comparison = Character.compare(this.charAt(i), other.charAt(i));
            if (comparison == 0) continue;
            return comparison;
        }
        return Integer.compare(this.length(), other.length());
    }

    public List<ByteString> split(char delim) {
        ArrayList<ByteString> parts = new ArrayList<ByteString>();
        int startOfPart = 0;
        for (int i = 0; i < this.length(); ++i) {
            if (this.charAt(i) != delim) continue;
            parts.add(this.subSequence(startOfPart, i));
            startOfPart = i + 1;
        }
        parts.add(this.subSequence(startOfPart, this.length()));
        return parts;
    }
}

