/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.urlcanon;

import java.util.regex.Pattern;
import org.netpreserve.urlcanon.ByteString;
import org.netpreserve.urlcanon.Canonicalizer;
import org.netpreserve.urlcanon.ParsedUrl;
import org.netpreserve.urlcanon.SemanticPreciseCanonicalizer;

public class AggressiveCanonicalizer
implements Canonicalizer {
    private static final Pattern WWW_RE = Pattern.compile("^www[0-9]*\\.");
    private static final Pattern QUERY_SESSIONID_RE = Pattern.compile("(?i)(?<=&|^)(?:jsessionid=[0-9a-z$]{10,}|sessionid=[0-9a-z]{16,}|phpsessid=[0-9a-z]{16,}|sid=[0-9a-z]{16,}|aspsessionid[a-z]{8}=[0-9a-z]{16,}|cfid=[0-9]+&cftoken=[0-9a-z-]+)(?:&|$)");
    private static final Pattern ASPX_SUFFIX_RE = Pattern.compile(".*\\.aspx$");
    private static final Pattern ASPX_PATH_SESSIONID_RE = Pattern.compile("(?<=/)\\([0-9a-z]{24}\\)/|(?<=/)(?:\\((?:[a-z]\\([0-9a-z]{24}\\))+\\)/)");
    private static final Pattern PATH_SESSIONID_RE = Pattern.compile(";jsessionid=[0-9a-z]{32}$");
    private static final Pattern REDUNDANT_AMPERSANDS_RE = Pattern.compile("^&+|&+$|(?<=&)&+");

    @Override
    public void canonicalize(ParsedUrl url) {
        Canonicalizer.SEMANTIC.canonicalize(url);
        AggressiveCanonicalizer.httpsToHttp(url);
        AggressiveCanonicalizer.stripWww(url);
        AggressiveCanonicalizer.lowercasePath(url);
        AggressiveCanonicalizer.lowercaseQuery(url);
        AggressiveCanonicalizer.stripSessionIdsFromQuery(url);
        AggressiveCanonicalizer.stripSessionIdsFromPath(url);
        AggressiveCanonicalizer.removeRedundantAmpersandsFromQuery(url);
        this.omitQuestionMarkIfQueryEmpty(url);
        SemanticPreciseCanonicalizer.alphaReorderQuery(url);
    }

    static void httpsToHttp(ParsedUrl url) {
        if (url.getScheme().equalsIgnoreCase("https")) {
            url.setScheme(new ByteString("http"));
        }
    }

    static void stripWww(ParsedUrl url) {
        url.setHost(url.getHost().replaceAll(WWW_RE, ""));
    }

    static void lowercasePath(ParsedUrl url) {
        url.setPath(url.getPath().asciiLowerCase());
    }

    static void lowercaseQuery(ParsedUrl url) {
        url.setQuery(url.getQuery().asciiLowerCase());
    }

    static void stripSessionIdsFromQuery(ParsedUrl url) {
        url.setQuery(url.getQuery().replaceAll(QUERY_SESSIONID_RE, ""));
    }

    static void stripSessionIdsFromPath(ParsedUrl url) {
        ByteString path = url.getPath();
        if (ASPX_SUFFIX_RE.matcher(path).matches()) {
            path = path.replaceAll(ASPX_PATH_SESSIONID_RE, "");
        }
        path = path.replaceAll(PATH_SESSIONID_RE, "");
        url.setPath(path);
    }

    static void removeRedundantAmpersandsFromQuery(ParsedUrl url) {
        url.setQuery(url.getQuery().replaceAll(REDUNDANT_AMPERSANDS_RE, ""));
    }

    private void omitQuestionMarkIfQueryEmpty(ParsedUrl url) {
        if (url.getQuery().isEmpty()) {
            url.setQuestionMark(ByteString.EMPTY);
        }
    }
}

