/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.query.result;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.nervousync.database.beans.configs.column.ColumnConfig;
import org.nervousync.database.beans.parser.AbstractDataParser;
import org.nervousync.database.beans.parser.impl.Base64DataParser;
import org.nervousync.database.beans.parser.impl.BooleanDataParser;
import org.nervousync.database.beans.parser.impl.DatetimeDataParser;
import org.nervousync.database.beans.parser.impl.NumberDataParser;
import org.nervousync.database.entity.EntityManager;
import org.nervousync.database.entity.core.BaseObject;
import org.nervousync.database.exceptions.entity.TableConfigException;
import org.nervousync.database.exceptions.security.DataModifiedException;
import org.nervousync.enumerations.xml.DataType;
import org.nervousync.utils.ObjectUtils;
import org.nervousync.utils.ReflectionUtils;
import org.nervousync.utils.StringUtils;

public final class ResultMap
extends HashMap<String, String> {
    public ResultMap() {
    }

    public ResultMap(Map<String, String> map) {
        this();
        this.putAll(map);
    }

    public <T> T unwrap(Class<T> clazz, boolean forUpdate, long identifyCode, long transactionalCode) throws TableConfigException, DataModifiedException {
        if (ResultMap.class.equals(clazz)) {
            return clazz.cast(this);
        }
        return (T)Optional.ofNullable(EntityManager.getInstance().retrieveTableConfig(clazz)).map(tableConfig -> {
            Object returnObject;
            try {
                returnObject = ObjectUtils.newInstance((Class)clazz);
                tableConfig.getColumnConfigList().stream().filter(columnConfig -> this.containsKey(columnConfig.getColumnName().toUpperCase())).forEach((? super T columnConfig) -> this.processFieldValue((ColumnConfig)columnConfig, returnObject, returnObject));
                ((BaseObject)returnObject).setForUpdate(forUpdate);
                ((BaseObject)returnObject).setTransactionalCode(transactionalCode);
            }
            catch (Exception e) {
                throw new TableConfigException("Convert result map to object error! ", e);
            }
            tableConfig.verify(returnObject, identifyCode);
            return returnObject;
        }).orElseThrow(() -> new TableConfigException("Can't found table define! "));
    }

    private void processFieldValue(ColumnConfig columnConfig, Object returnObject, Object compositeId) {
        AbstractDataParser dataParser = AbstractDataParser.class.equals(columnConfig.getParserClass()) ? (DataType.NUMBER.equals((Object)ObjectUtils.retrieveSimpleDataType(columnConfig.getFieldType())) ? new NumberDataParser() : (Boolean.TYPE.equals(columnConfig.getFieldType()) || Boolean.class.equals(columnConfig.getFieldType()) ? new BooleanDataParser() : (Date.class.equals(columnConfig.getFieldType()) ? new DatetimeDataParser() : (byte[].class.equals(columnConfig.getFieldType()) ? new Base64DataParser() : null)))) : (AbstractDataParser)ObjectUtils.newInstance(columnConfig.getParserClass());
        Object fieldValue = this.get(columnConfig.getColumnName().toUpperCase());
        if (dataParser != null) {
            fieldValue = dataParser.parse((String)fieldValue, columnConfig.getFieldType());
        }
        if (fieldValue == null) {
            return;
        }
        if (columnConfig.isPrimaryKeyColumn()) {
            ReflectionUtils.setField((String)columnConfig.getFieldName(), (Object)compositeId, fieldValue);
        } else {
            ReflectionUtils.setField((String)columnConfig.getFieldName(), (Object)returnObject, fieldValue);
        }
    }

    public String cacheData() {
        return StringUtils.objectToString((Object)this, (StringUtils.StringType)StringUtils.StringType.JSON, (boolean)Boolean.TRUE);
    }
}

