/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.query.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.nervousync.database.beans.configs.table.TableConfig;
import org.nervousync.database.entity.EntityManager;
import org.nervousync.database.enumerations.join.JoinType;
import org.nervousync.database.exceptions.entity.EntityStatusException;
import org.nervousync.database.exceptions.record.QueryException;
import org.nervousync.database.query.condition.MatchCondition;
import org.nervousync.database.query.condition.QueryCondition;
import org.nervousync.database.query.core.QueryItem;
import org.nervousync.database.query.core.QueryJoin;
import org.nervousync.database.query.operate.ConditionCode;
import org.nervousync.database.query.operate.ConnectionCode;
import org.nervousync.utils.ConvertUtils;
import org.nervousync.utils.SecurityUtils;
import org.nervousync.utils.StringUtils;

public final class QueryTable {
    private final String aliasName;
    private final String tableName;
    private final Class<?> entityClass;
    private final String schemaName;
    private final List<QueryJoin> queryJoinList;
    private final List<QueryItem> queryItemList;
    private final List<QueryCondition> queryConditionList;

    private QueryTable(TableConfig tableConfig, String aliasName, List<QueryJoin> queryJoinList, List<QueryItem> queryItemList, List<QueryCondition> queryConditionList) {
        this.aliasName = StringUtils.isEmpty((CharSequence)aliasName) ? StringUtils.randomString((int)4) : aliasName;
        this.tableName = tableConfig.getTableName();
        this.entityClass = tableConfig.getDefineClass();
        this.schemaName = tableConfig.getSchemaName();
        this.queryJoinList = queryJoinList;
        this.queryItemList = queryItemList;
        this.queryConditionList = queryConditionList;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public List<QueryJoin> getQueryJoinList() {
        return this.queryJoinList;
    }

    public List<QueryItem> getQueryItemList() {
        return this.queryItemList;
    }

    public List<QueryCondition> getQueryConditionList() {
        return this.queryConditionList;
    }

    public void addQueryCondition(ConnectionCode connCode, ConditionCode conditionCode, String identifyName, MatchCondition matchCondition) throws QueryException {
        if (this.queryConditionList.stream().noneMatch(queryCondition -> queryCondition.match(connCode, conditionCode, identifyName, matchCondition))) {
            this.queryConditionList.add(new QueryCondition(connCode, conditionCode, identifyName, matchCondition));
        }
    }

    public static QueryBuilder newBuilder(String aliasName, Class<?> entityClass, int countPrefix) {
        return new QueryBuilder(aliasName, entityClass, countPrefix * 10);
    }

    public String cacheKey() {
        TreeMap<String, Object> cacheMap = new TreeMap<String, Object>();
        cacheMap.put("TableName", this.tableName);
        cacheMap.put("SchemaName", this.schemaName);
        HashMap joinMap = new HashMap();
        this.queryJoinList.forEach(queryJoin -> joinMap.put(queryJoin.getJoinType().toString(), queryJoin.getQueryTable().getTableName()));
        cacheMap.put("QueryJoin", joinMap);
        ArrayList queryItems = new ArrayList();
        this.queryItemList.forEach(queryItem -> queryItems.add(queryItem.cacheKey()));
        queryItems.sort(String::compareTo);
        cacheMap.put("QueryItems", queryItems);
        ArrayList conditionList = new ArrayList();
        this.queryConditionList.forEach(queryCondition -> conditionList.add(queryCondition.cacheKey()));
        conditionList.sort(String::compareTo);
        cacheMap.put("ConditionList", conditionList);
        return ConvertUtils.byteToHex((byte[])SecurityUtils.SHA256(cacheMap));
    }

    public static final class QueryBuilder {
        private final String aliasName;
        private final TableConfig tableConfig;
        private final List<QueryJoin.JoinBuilder> joinBuilderList;
        private final List<QueryItem> queryItemList;
        private final List<QueryCondition> queryConditionList;
        private final AtomicInteger countPrefix;

        private QueryBuilder(String aliasName, Class<?> entityClass, int countPrefix) throws EntityStatusException {
            if (entityClass == null) {
                throw new EntityStatusException("Entity class is null");
            }
            this.tableConfig = EntityManager.getInstance().retrieveTableConfig(entityClass);
            if (this.tableConfig == null) {
                throw new EntityStatusException("Entity not found! ");
            }
            this.countPrefix = new AtomicInteger(countPrefix);
            this.aliasName = StringUtils.isEmpty((CharSequence)aliasName) ? "T_" + this.countPrefix : aliasName;
            this.joinBuilderList = new ArrayList<QueryJoin.JoinBuilder>();
            this.queryItemList = new ArrayList<QueryItem>();
            this.queryConditionList = new ArrayList<QueryCondition>();
        }

        public void joinTable(JoinType joinType, String aliasName, Class<?> entityClass, Class<?> referenceClass) throws EntityStatusException {
            if (entityClass == null) {
                throw new EntityStatusException("Entity class is null");
            }
            if (this.match(entityClass)) {
                this.addJoinTable(joinType, aliasName, referenceClass);
            } else {
                this.joinBuilderList.forEach(joinBuilder -> joinBuilder.addJoinTable(joinType, aliasName, entityClass, referenceClass));
            }
        }

        void addJoinTable(JoinType joinType, String aliasName, Class<?> referenceClass) {
            if (referenceClass == null) {
                throw new EntityStatusException("Reference class is null");
            }
            for (QueryJoin.JoinBuilder joinBuilder : this.joinBuilderList) {
                if (!joinBuilder.match(referenceClass)) continue;
                return;
            }
            QueryJoin.JoinBuilder joinBuilder = Optional.ofNullable(this.tableConfig.findReferenceConfig(referenceClass.getName())).map(referenceConfig -> {
                QueryJoin.JoinBuilder builder = QueryJoin.newBuilder(joinType, aliasName, referenceClass, this.countPrefix.incrementAndGet());
                referenceConfig.getReferenceColumnList().forEach(joinColumnConfig -> builder.addJoinColumn(joinColumnConfig.getCurrentField(), joinColumnConfig.getReferenceField()));
                return builder;
            }).orElseThrow(() -> new EntityStatusException("Reference config not found! "));
            this.joinBuilderList.add(joinBuilder);
        }

        public void addQueryColumn(Class<?> entityClass, String identifyName, boolean distinct, String aliasName) throws QueryException {
            if (this.match(entityClass)) {
                this.addQueryItem(QueryItem.queryColumn(identifyName, distinct, aliasName));
            } else {
                this.joinBuilderList.forEach(joinBuilder -> joinBuilder.addQueryColumn(entityClass, identifyName, distinct, aliasName));
            }
        }

        public void addQueryFunction(Class<?> entityClass, String aliasName, String sqlFunction, QueryItem ... functionParams) throws QueryException {
            if (this.match(entityClass)) {
                this.addQueryItem(QueryItem.queryFunction(aliasName, sqlFunction, functionParams));
            } else {
                this.joinBuilderList.stream().filter(joinBuilder -> joinBuilder.match(entityClass)).forEach(joinBuilder -> joinBuilder.addQueryFunction(entityClass, aliasName, sqlFunction, functionParams));
            }
        }

        public void addQueryCondition(Class<?> entityClass, ConnectionCode connCode, ConditionCode conditionCode, String identifyName, MatchCondition matchCondition) throws QueryException {
            if (this.match(entityClass)) {
                this.addQueryCondition(new QueryCondition(connCode, conditionCode, identifyName, matchCondition));
            } else {
                this.joinBuilderList.forEach(joinBuilder -> joinBuilder.addQueryCondition(entityClass, connCode, conditionCode, identifyName, matchCondition));
            }
        }

        public QueryTable build() {
            ArrayList<QueryJoin> queryJoinList = new ArrayList<QueryJoin>();
            this.joinBuilderList.forEach(joinBuilder -> queryJoinList.add(joinBuilder.build()));
            return new QueryTable(this.tableConfig, this.aliasName, queryJoinList, this.queryItemList, this.queryConditionList);
        }

        public boolean contains(Class<?> entityClass) {
            if (this.tableConfig.getDefineClass().equals(entityClass)) {
                return true;
            }
            for (QueryJoin.JoinBuilder joinBuilder : this.joinBuilderList) {
                if (!joinBuilder.match(entityClass)) continue;
                return true;
            }
            return Boolean.FALSE;
        }

        boolean match(Class<?> entityClass) {
            return this.tableConfig.getDefineClass().equals(entityClass);
        }

        public boolean match(String schemaName) {
            return Objects.equals(this.tableConfig.getSchemaName(), schemaName);
        }

        public boolean analyzeCheck(Class<?> entityClass, Class<?> referenceClass) {
            if (this.match(entityClass)) {
                return this.analyzeCheck(referenceClass);
            }
            for (QueryJoin.JoinBuilder joinBuilder : this.joinBuilderList) {
                if (!joinBuilder.match(entityClass)) continue;
                return joinBuilder.analyzeCheck(referenceClass);
            }
            return Boolean.FALSE;
        }

        boolean analyzeCheck(Class<?> referenceClass) {
            return Optional.ofNullable(EntityManager.getInstance().retrieveTableConfig(referenceClass)).map(referenceTable -> Objects.equals(this.tableConfig.getSchemaName(), referenceTable.getSchemaName())).orElse(Boolean.FALSE);
        }

        void addQueryItem(QueryItem queryItem) {
            if (this.queryItemList.stream().noneMatch(currentItem -> currentItem.match(queryItem))) {
                this.queryItemList.add(queryItem);
            }
        }

        void addQueryCondition(QueryCondition queryCondition) {
            if (this.queryConditionList.stream().noneMatch(curCondition -> curCondition.equals(queryCondition))) {
                this.queryConditionList.add(queryCondition);
            }
        }
    }
}

