/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.query.core;

import java.util.ArrayList;
import java.util.List;
import org.nervousync.database.enumerations.join.JoinType;
import org.nervousync.database.exceptions.entity.EntityStatusException;
import org.nervousync.database.exceptions.record.QueryException;
import org.nervousync.database.query.condition.MatchCondition;
import org.nervousync.database.query.core.JoinColumn;
import org.nervousync.database.query.core.QueryItem;
import org.nervousync.database.query.core.QueryTable;
import org.nervousync.database.query.operate.ConditionCode;
import org.nervousync.database.query.operate.ConnectionCode;
import org.nervousync.utils.StringUtils;

public final class QueryJoin {
    private final JoinType joinType;
    private final QueryTable queryTable;
    private final List<JoinColumn> joinColumns;

    private QueryJoin(JoinType joinType, QueryTable queryTable, List<JoinColumn> joinColumns) {
        this.joinType = joinType;
        this.queryTable = queryTable;
        this.joinColumns = joinColumns;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public QueryTable getQueryTable() {
        return this.queryTable;
    }

    public List<JoinColumn> getJoinColumns() {
        return this.joinColumns;
    }

    static JoinBuilder newBuilder(JoinType joinType, String aliasName, Class<?> entityClass, int countPrefix) {
        return new JoinBuilder(joinType, aliasName, entityClass, countPrefix);
    }

    static final class JoinBuilder {
        private final JoinType joinType;
        private final QueryTable.QueryBuilder queryBuilder;
        private final List<JoinColumn> joinColumns;

        private JoinBuilder(JoinType joinType, String aliasName, Class<?> entityClass, int countPrefix) {
            this.joinType = joinType;
            this.queryBuilder = QueryTable.newBuilder(aliasName, entityClass, countPrefix);
            this.joinColumns = new ArrayList<JoinColumn>();
        }

        void addJoinColumn(String joinKey, String identifyName) {
            if (StringUtils.isEmpty((CharSequence)joinKey)) {
                return;
            }
            if (StringUtils.isEmpty((CharSequence)identifyName)) {
                return;
            }
            for (JoinColumn joinColumn : this.joinColumns) {
                if (!joinColumn.getJoinKey().equalsIgnoreCase(joinKey) || !joinColumn.getReferenceKey().equalsIgnoreCase(identifyName)) continue;
                return;
            }
            this.joinColumns.add(new JoinColumn(joinKey, identifyName));
        }

        QueryJoin build() {
            if (this.joinColumns.isEmpty()) {
                throw new QueryException("Join columns must not be empty");
            }
            return new QueryJoin(this.joinType, this.queryBuilder.build(), this.joinColumns);
        }

        boolean match(Class<?> entityClass) {
            return this.queryBuilder.match(entityClass);
        }

        boolean analyzeCheck(Class<?> referenceClass) {
            return this.queryBuilder.analyzeCheck(referenceClass);
        }

        void addQueryColumn(Class<?> entityClass, String identifyName, boolean distinct, String aliasName) {
            this.queryBuilder.addQueryColumn(entityClass, identifyName, distinct, aliasName);
        }

        void addQueryFunction(Class<?> entityClass, String aliasName, String sqlFunction, QueryItem ... functionParams) throws QueryException {
            this.queryBuilder.addQueryFunction(entityClass, aliasName, sqlFunction, functionParams);
        }

        void addJoinTable(JoinType joinType, String aliasName, Class<?> entityClass, Class<?> referenceClass) {
            if (entityClass == null) {
                throw new EntityStatusException("Entity class is null");
            }
            if (this.queryBuilder.match(entityClass)) {
                this.queryBuilder.addJoinTable(joinType, aliasName, referenceClass);
            }
        }

        void addQueryCondition(Class<?> entityClass, ConnectionCode connectionCode, ConditionCode conditionCode, String identifyName, MatchCondition matchCondition) {
            this.queryBuilder.addQueryCondition(entityClass, connectionCode, conditionCode, identifyName, matchCondition);
        }
    }
}

