/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.query.core;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.nervousync.utils.ConvertUtils;
import org.nervousync.utils.SecurityUtils;

public abstract class QueryItem {
    private static final String CACHE_KEY_ITEM_TYPE = "ItemType";
    private static final String CACHE_KEY_ALIAS_NAME = "AliasName";
    private final ItemType itemType;
    private final String aliasName;

    private QueryItem(ItemType itemType, String aliasName) {
        this.itemType = itemType;
        this.aliasName = aliasName;
    }

    public static QueryColumn queryColumn(String identifyKey, boolean distinct, String aliasName) {
        return new QueryColumn(identifyKey, distinct, aliasName);
    }

    public static QueryConstant queryConstant(Object constantValue) {
        return new QueryConstant(constantValue);
    }

    public static QueryFunction queryFunction(String aliasName, String sqlFunction, QueryItem ... functionParams) {
        return new QueryFunction(aliasName, sqlFunction, functionParams);
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public abstract boolean match(QueryItem var1);

    public abstract String cacheKey();

    public static enum ItemType {
        COLUMN,
        FUNCTION,
        CONSTANT;

    }

    public static final class QueryColumn
    extends QueryItem {
        private final String identifyKey;
        private final boolean distinct;

        private QueryColumn(String identifyKey, boolean distinct, String aliasName) {
            super(ItemType.COLUMN, aliasName);
            this.identifyKey = identifyKey;
            this.distinct = distinct;
        }

        @Override
        public boolean match(QueryItem queryItem) {
            if (queryItem == null) {
                return Boolean.FALSE;
            }
            if (ItemType.COLUMN.equals((Object)queryItem.getItemType())) {
                return this.identifyKey.equalsIgnoreCase(((QueryColumn)queryItem).getIdentifyKey()) && Objects.equals(this.distinct, ((QueryColumn)queryItem).isDistinct());
            }
            return Boolean.FALSE;
        }

        @Override
        public String cacheKey() {
            HashMap<String, Object> cacheMap = new HashMap<String, Object>();
            cacheMap.put(QueryItem.CACHE_KEY_ITEM_TYPE, ItemType.COLUMN.toString());
            cacheMap.put(QueryItem.CACHE_KEY_ALIAS_NAME, this.getAliasName());
            cacheMap.put("IdentifyKey", this.identifyKey);
            cacheMap.put("Distinct", this.distinct);
            return ConvertUtils.byteToHex((byte[])SecurityUtils.SHA256(cacheMap));
        }

        public String getIdentifyKey() {
            return this.identifyKey;
        }

        public boolean isDistinct() {
            return this.distinct;
        }
    }

    public static final class QueryConstant
    extends QueryItem {
        private final Object constantValue;

        private QueryConstant(Object constantValue) {
            super(ItemType.CONSTANT, "");
            this.constantValue = constantValue;
        }

        @Override
        public boolean match(QueryItem queryItem) {
            if (queryItem == null) {
                return Boolean.FALSE;
            }
            if (ItemType.CONSTANT.equals((Object)queryItem.getItemType())) {
                return Objects.equals(this.constantValue, ((QueryConstant)queryItem).getConstantValue());
            }
            return Boolean.FALSE;
        }

        @Override
        public String cacheKey() {
            HashMap<String, Object> cacheMap = new HashMap<String, Object>();
            cacheMap.put(QueryItem.CACHE_KEY_ITEM_TYPE, ItemType.CONSTANT.toString());
            cacheMap.put(QueryItem.CACHE_KEY_ALIAS_NAME, this.getAliasName());
            cacheMap.put("ItemValue", this.constantValue);
            return ConvertUtils.byteToHex((byte[])SecurityUtils.SHA256(cacheMap));
        }

        public Object getConstantValue() {
            return this.constantValue;
        }
    }

    @XmlRootElement
    public static final class QueryFunction
    extends QueryItem {
        private static final long serialVersionUID = 4463684389449026498L;
        @XmlElement
        private final String sqlFunction;
        @XmlElementWrapper
        private final List<QueryItem> functionParams;

        private QueryFunction(String aliasName, String sqlFunction, QueryItem ... functionParams) {
            super(ItemType.FUNCTION, aliasName);
            this.sqlFunction = sqlFunction;
            this.functionParams = Arrays.asList(functionParams);
        }

        public static long getSerialVersionUID() {
            return 4463684389449026498L;
        }

        @Override
        public boolean match(QueryItem queryItem) {
            if (queryItem == null) {
                return Boolean.FALSE;
            }
            if (ItemType.FUNCTION.equals((Object)queryItem.getItemType())) {
                return this.sqlFunction.equalsIgnoreCase(((QueryFunction)queryItem).getSQLFunction()) && Objects.deepEquals(this.functionParams, ((QueryFunction)queryItem).getFunctionParams());
            }
            return Boolean.FALSE;
        }

        @Override
        public String cacheKey() {
            ArrayList itemValues = new ArrayList();
            this.functionParams.forEach(queryItem -> itemValues.add(queryItem.cacheKey()));
            itemValues.sort(String::compareTo);
            HashMap<String, Object> cacheMap = new HashMap<String, Object>();
            cacheMap.put(QueryItem.CACHE_KEY_ITEM_TYPE, ItemType.FUNCTION.toString());
            cacheMap.put(QueryItem.CACHE_KEY_ALIAS_NAME, this.getAliasName());
            cacheMap.put("Function", this.sqlFunction);
            cacheMap.put("ItemValue", itemValues);
            return ConvertUtils.byteToHex((byte[])SecurityUtils.SHA256(cacheMap));
        }

        public String getSQLFunction() {
            return this.sqlFunction;
        }

        public List<QueryItem> getFunctionParams() {
            return this.functionParams;
        }
    }
}

