/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.query.condition;

import java.util.HashMap;
import java.util.Objects;
import org.nervousync.database.query.condition.MatchCondition;
import org.nervousync.database.query.operate.ConditionCode;
import org.nervousync.database.query.operate.ConnectionCode;
import org.nervousync.utils.ConvertUtils;
import org.nervousync.utils.SecurityUtils;

public record QueryCondition(ConnectionCode connectionCode, ConditionCode conditionCode, String identifyKey, MatchCondition matchCondition) {
    public boolean match(ConnectionCode connectionCode, ConditionCode conditionCode, String identifyKey, MatchCondition matchCondition) {
        return Objects.equals((Object)this.connectionCode, (Object)connectionCode) && Objects.equals((Object)this.conditionCode, (Object)conditionCode) && Objects.equals(this.identifyKey, identifyKey) && Objects.equals(this.matchCondition, matchCondition);
    }

    public String cacheKey() {
        HashMap<String, String> cacheMap = new HashMap<String, String>();
        cacheMap.put("ConnectionCode", this.connectionCode.toString());
        cacheMap.put("ConditionCode", this.conditionCode.toString());
        cacheMap.put("IdentifyKey", this.identifyKey);
        cacheMap.put("MatchCondition", this.matchCondition.cacheKey());
        return ConvertUtils.byteToHex((byte[])SecurityUtils.SHA256(cacheMap));
    }

    public static enum ConditionType {
        CONSTANT,
        GROUP,
        DYNAMIC;

    }
}

