/*
 * Decompiled with CFR 0.152.
 */
package org.nervousync.database.query.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.nervousync.database.query.condition.QueryCondition;
import org.nervousync.utils.ConvertUtils;
import org.nervousync.utils.SecurityUtils;

public final class MatchCondition {
    private final QueryCondition.ConditionType conditionType;
    private final long planCode;
    private final String identifyKey;
    private final Object[] matchValues;

    private MatchCondition(long planCode, String identifyKey) {
        this.conditionType = QueryCondition.ConditionType.DYNAMIC;
        this.planCode = planCode;
        this.identifyKey = identifyKey;
        this.matchValues = new Object[0];
    }

    private MatchCondition(Object ... matchValues) {
        this.conditionType = QueryCondition.ConditionType.CONSTANT;
        this.planCode = -1L;
        this.identifyKey = "";
        this.matchValues = matchValues;
    }

    private MatchCondition(QueryCondition ... queryConditions) {
        this.conditionType = QueryCondition.ConditionType.GROUP;
        this.planCode = -1L;
        this.identifyKey = "";
        this.matchValues = queryConditions;
    }

    public static MatchCondition dynamic(long planCode, String identifyKey) {
        return new MatchCondition(planCode, identifyKey);
    }

    public static MatchCondition condition(Object ... matchValues) {
        return new MatchCondition(matchValues);
    }

    public static MatchCondition group(QueryCondition ... queryConditions) {
        return new MatchCondition(queryConditions);
    }

    public QueryCondition.ConditionType getConditionType() {
        return this.conditionType;
    }

    public long getPlanCode() {
        return this.planCode;
    }

    public String getIdentifyKey() {
        return this.identifyKey;
    }

    public Object[] getMatchValues() {
        return this.matchValues;
    }

    public String cacheKey() {
        HashMap<String, Object> cacheMap = new HashMap<String, Object>();
        cacheMap.put("ConditionType", this.conditionType.toString());
        cacheMap.put("IdentifyKey", this.identifyKey);
        if (QueryCondition.ConditionType.GROUP.equals((Object)this.conditionType)) {
            ArrayList conditionValues = new ArrayList();
            Arrays.asList(this.matchValues).forEach(matchValue -> conditionValues.add(((MatchCondition)matchValue).cacheKey()));
            conditionValues.sort(String::compareTo);
            cacheMap.put("MatchValues", conditionValues);
        } else {
            cacheMap.put("MatchValues", this.matchValues);
        }
        return ConvertUtils.byteToHex((byte[])SecurityUtils.SHA256(cacheMap));
    }
}

